/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.modules.editor.document.implspi.DocumentServiceFactory;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class DocumentServices {
    private static volatile DocumentServices INSTANCE;
    private Map<Class<?>, Lookup.Result<DocumentServiceFactory<?>>> factoryMap = new HashMap(5);
    private static final Object STUB_KEY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DocumentServices getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DocumentServices> clazz = DocumentServices.class;
        synchronized (DocumentServices.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DocumentServices();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void initDocumentServices(Document doc) {
        this.doInitDocumentServices(doc, doc.getClass());
    }

    private Lookup.Result<DocumentServiceFactory<?>> initDocumentFactories(Class<?> c) {
        Lookup.Result<DocumentServiceFactory<?>> lookupResult;
        ArrayList<Lookup> lkps = new ArrayList<Lookup>(5);
        do {
            String cn;
            if ((cn = c.getCanonicalName()) == null) continue;
            lkps.add(Lookups.forPath("Editors/Documents/" + cn));
        } while ((c = c.getSuperclass()) != null && c != Object.class);
        Lookup[] arr = lkps.toArray(new Lookup[lkps.size()]);
        Lookup.Result<DocumentServiceFactory<?>> res = lookupResult = new ProxyLookup(arr).lookupResult(DocumentServiceFactory.class);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D extends Document> Lookup doInitDocumentServices(D doc, Class<?> c) {
        Lookup.Result<DocumentServiceFactory<?>> factories;
        boolean stub = c != doc.getClass();
        Class<DocumentServices> k = stub ? STUB_KEY : DocumentServices.class;
        Lookup res = (Lookup)doc.getProperty(k);
        if (res != null) {
            return res;
        }
        DocumentServices documentServices = this;
        synchronized (documentServices) {
            factories = this.factoryMap.get(c);
            if (factories == null) {
                factories = this.initDocumentFactories(c);
                this.factoryMap.put(c, factories);
            }
        }
        Collection<DocumentServiceFactory<?>> col = factories.allInstances();
        ArrayList<Lookup> lkps = new ArrayList<Lookup>(col.size());
        for (DocumentServiceFactory<?> f : col) {
            try {
                Lookup l = f.forDocument(doc);
                if (l == null) continue;
                lkps.add(l);
            }
            catch (Exception exception) {}
        }
        res = new ProxyLookup(lkps.toArray(new Lookup[lkps.size()]));
        doc.putProperty(k, res);
        return res;
    }

    public Lookup getStubLookup(Document doc) {
        return this.doInitDocumentServices(doc, Document.class);
    }

    public Lookup getLookup(Document doc) {
        return this.doInitDocumentServices(doc, doc.getClass());
    }

    static {
        STUB_KEY = DocumentServices.class.getName() + ".stub";
    }
}

