/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.support.DelegatingLookupImpl;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public final class LookupProviderSupport {
    private LookupProviderSupport() {
    }

    public static Lookup createCompositeLookup(Lookup baseLookup, String folderPath) {
        return new DelegatingLookupImpl(baseLookup, Lookups.forPath(folderPath), folderPath);
    }

    public static Lookup createCompositeLookup(Lookup baseLookup, Lookup providers) {
        return new DelegatingLookupImpl(baseLookup, providers, "<multiplePaths>");
    }

    public static LookupMerger<Sources> createSourcesMerger() {
        return new SourcesMerger();
    }

    public static LookupMerger<ActionProvider> createActionProviderMerger() {
        return new ActionProviderMerger();
    }

    public static LookupMerger<SharabilityQueryImplementation2> createSharabilityQueryMerger() {
        return new SharabilityQueryMerger();
    }

    private static final class MergedSharabilityQueryImplementation2
    implements SharabilityQueryImplementation2 {
        private final Lookup.Result<? extends SharabilityQueryImplementation2> lkpResult;

        MergedSharabilityQueryImplementation2(@NonNull Lookup lkp) {
            this.lkpResult = lkp.lookupResult(SharabilityQueryImplementation2.class);
        }

        @Override
        public SharabilityQuery.Sharability getSharability(URI uri) {
            for (SharabilityQueryImplementation2 sharabilityQueryImplementation2 : this.lkpResult.allInstances()) {
                SharabilityQuery.Sharability res = sharabilityQueryImplementation2.getSharability(uri);
                if (res == SharabilityQuery.Sharability.UNKNOWN) continue;
                return res;
            }
            return SharabilityQuery.Sharability.UNKNOWN;
        }
    }

    private static final class SharabilityQueryMerger
    implements LookupMerger<SharabilityQueryImplementation2> {
        private SharabilityQueryMerger() {
        }

        @Override
        public Class<SharabilityQueryImplementation2> getMergeableClass() {
            return SharabilityQueryImplementation2.class;
        }

        @Override
        public SharabilityQueryImplementation2 merge(Lookup lookup) {
            return new MergedSharabilityQueryImplementation2(lookup);
        }
    }

    private static final class MergedActionProvider
    implements ActionProvider,
    LookupListener {
        private final Lookup.Result<ActionProvider> lkpResult;
        private volatile String[] actionNamesCache;

        private MergedActionProvider(Lookup lkp) {
            this.lkpResult = lkp.lookupResult(ActionProvider.class);
            this.lkpResult.addLookupListener(this);
        }

        @Override
        public String[] getSupportedActions() {
            String[] result = this.actionNamesCache;
            if (result == null) {
                LinkedHashSet<String> actionNames = new LinkedHashSet<String>();
                for (ActionProvider ap : this.lkpResult.allInstances()) {
                    actionNames.addAll(Arrays.asList(ap.getSupportedActions()));
                }
                result = actionNames.toArray(new String[actionNames.size()]);
                this.actionNamesCache = result;
            }
            assert (result != null);
            return result;
        }

        @Override
        public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
            boolean found = false;
            for (ActionProvider ap : this.lkpResult.allInstances()) {
                if (!Arrays.asList(ap.getSupportedActions()).contains(command)) continue;
                if (ap.isActionEnabled(command, context)) {
                    return true;
                }
                found = true;
            }
            if (found) {
                return false;
            }
            throw new IllegalArgumentException("Misimplemented command '" + command + "' in " + Arrays.toString(this.lkpResult.allInstances().toArray()));
        }

        @Override
        public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
            for (ActionProvider ap : this.lkpResult.allInstances()) {
                if (!Arrays.asList(ap.getSupportedActions()).contains(command) || !ap.isActionEnabled(command, context)) continue;
                ap.invokeAction(command, context);
                return;
            }
            throw new IllegalArgumentException(String.format(command, new Object[0]));
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            this.actionNamesCache = null;
        }
    }

    private static final class ActionProviderMerger
    implements LookupMerger<ActionProvider> {
        private ActionProviderMerger() {
        }

        @Override
        public Class<ActionProvider> getMergeableClass() {
            return ActionProvider.class;
        }

        @Override
        public ActionProvider merge(Lookup lookup) {
            return new MergedActionProvider(lookup);
        }
    }

    private static class SourcesImpl
    implements Sources,
    ChangeListener,
    LookupListener {
        private final ChangeSupport changeSupport = new ChangeSupport(this);
        private final Lookup.Result<Sources> delegates;
        private Sources[] currentDelegates;

        SourcesImpl(Lookup lookup) {
            this.delegates = lookup.lookupResult(Sources.class);
            this.delegates.addLookupListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SourceGroup[] getSourceGroups(String type) {
            Sources[] _currentDelegates;
            assert (this.delegates != null);
            SourcesImpl sourcesImpl = this;
            synchronized (sourcesImpl) {
                if (this.currentDelegates == null) {
                    Collection<Sources> instances = this.delegates.allInstances();
                    Sources[] sourcesArray = this.currentDelegates = instances.toArray(new Sources[instances.size()]);
                    int n = sourcesArray.length;
                    for (int i = 0; i < n; ++i) {
                        Sources ns = sourcesArray[i];
                        ns.addChangeListener(this);
                    }
                }
                _currentDelegates = this.currentDelegates;
            }
            ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
            for (Sources ns : _currentDelegates) {
                SourceGroup[] sourceGroups = ns.getSourceGroups(type);
                if (sourceGroups == null) continue;
                for (SourceGroup sourceGroup : sourceGroups) {
                    if (sourceGroup == null) {
                        Exceptions.printStackTrace(new NullPointerException(ns + " returns null source group!"));
                        continue;
                    }
                    result.add(sourceGroup);
                }
            }
            return result.toArray(new SourceGroup[result.size()]);
        }

        @Override
        public synchronized void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        @Override
        public synchronized void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.changeSupport.fireChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resultChanged(LookupEvent ev) {
            SourcesImpl sourcesImpl = this;
            synchronized (sourcesImpl) {
                if (this.currentDelegates != null) {
                    for (Sources old : this.currentDelegates) {
                        old.removeChangeListener(this);
                    }
                    this.currentDelegates = null;
                }
            }
            this.changeSupport.fireChange();
        }
    }

    private static class SourcesMerger
    implements LookupMerger<Sources> {
        private SourcesMerger() {
        }

        @Override
        public Class<Sources> getMergeableClass() {
            return Sources.class;
        }

        @Override
        public Sources merge(Lookup lookup) {
            return new SourcesImpl(lookup);
        }
    }
}

