/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.resource;

import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.EnforcePolicyPermissionsThroughBaseResource;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationAuthorizable
implements Authorizable,
EnforcePolicyPermissionsThroughBaseResource {
    private static Logger logger = LoggerFactory.getLogger(OperationAuthorizable.class);
    private final Authorizable baseAuthorizable;

    public OperationAuthorizable(Authorizable baseAuthorizable) {
        this.baseAuthorizable = baseAuthorizable;
    }

    public Authorizable getParentAuthorizable() {
        if (this.baseAuthorizable.getParentAuthorizable() == null) {
            return null;
        }
        return new OperationAuthorizable(this.baseAuthorizable.getParentAuthorizable());
    }

    @Override
    public Authorizable getBaseAuthorizable() {
        return this.baseAuthorizable;
    }

    public Resource getResource() {
        return ResourceFactory.getOperationResource(this.baseAuthorizable.getResource());
    }

    public static void authorizeOperation(Authorizable baseAuthorizable, Authorizer authorizer, NiFiUser user) {
        try {
            baseAuthorizable.authorize(authorizer, RequestAction.WRITE, user);
        }
        catch (AccessDeniedException e) {
            logger.debug("Authorization failed with {}. Try authorizing with OperationAuthorizable.", (Object)baseAuthorizable, (Object)e);
            new OperationAuthorizable(baseAuthorizable).authorize(authorizer, RequestAction.WRITE, user);
        }
    }

    public static boolean isOperationAuthorized(Authorizable baseAuthorizable, Authorizer authorizer, NiFiUser user) {
        return baseAuthorizable.isAuthorized(authorizer, RequestAction.WRITE, user) || new OperationAuthorizable(baseAuthorizable).isAuthorized(authorizer, RequestAction.WRITE, user);
    }
}

