/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.nifi.components.PropertyDependency;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.expression.ExpressionLanguageCompiler;

public interface ValidationContext
extends PropertyContext {
    public ControllerServiceLookup getControllerServiceLookup();

    public ValidationContext getControllerServiceValidationContext(ControllerService var1);

    public ExpressionLanguageCompiler newExpressionLanguageCompiler();

    public PropertyValue newPropertyValue(String var1);

    public Map<PropertyDescriptor, String> getProperties();

    public String getAnnotationData();

    public boolean isValidationRequired(ControllerService var1);

    public boolean isExpressionLanguagePresent(String var1);

    public boolean isExpressionLanguageSupported(String var1);

    public String getProcessGroupIdentifier();

    public Collection<String> getReferencedParameters(String var1);

    public boolean isParameterDefined(String var1);

    public boolean isParameterSet(String var1);

    default public boolean isDependencySatisfied(PropertyDescriptor propertyDescriptor, Function<String, PropertyDescriptor> propertyDescriptorLookup) {
        return this.isDependencySatisfied(propertyDescriptor, propertyDescriptorLookup, new HashSet<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDependencySatisfied(PropertyDescriptor propertyDescriptor, Function<String, PropertyDescriptor> propertyDescriptorLookup, Set<String> propertiesSeen) {
        Set<PropertyDependency> dependencies = propertyDescriptor.getDependencies();
        if (dependencies.isEmpty()) {
            return true;
        }
        boolean added = propertiesSeen.add(propertyDescriptor.getName());
        if (!added) {
            return false;
        }
        try {
            for (PropertyDependency dependency : dependencies) {
                String dependencyValue;
                String dependencyName = dependency.getPropertyName();
                PropertyDescriptor dependencyDescriptor = propertyDescriptorLookup.apply(dependencyName);
                if (dependencyDescriptor == null) {
                    boolean bl = false;
                    return bl;
                }
                PropertyValue propertyValue = this.getProperty(dependencyDescriptor);
                String string = dependencyValue = propertyValue == null ? dependencyDescriptor.getDefaultValue() : propertyValue.getValue();
                if (dependencyValue == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean transitiveDependencySatisfied = this.isDependencySatisfied(dependencyDescriptor, propertyDescriptorLookup, propertiesSeen);
                if (!transitiveDependencySatisfied) {
                    boolean bl = false;
                    return bl;
                }
                Set<String> dependentValues = dependency.getDependentValues();
                if (dependentValues == null || dependentValues.contains(dependencyValue)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            propertiesSeen.remove(propertyDescriptor.getName());
        }
    }

    default public boolean isValidateConnections() {
        return true;
    }
}

