/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import java.util.List;
import org.apache.nifi.web.api.dto.UpdateStepDTO;
import org.apache.nifi.web.api.dto.util.TimestampAdapter;

public abstract class AsynchronousRequestDTO<T extends UpdateStepDTO> {
    private String requestId;
    private String uri;
    private Date submissionTime;
    private Date lastUpdated;
    private boolean complete = false;
    private String failureReason;
    private int percentCompleted;
    private String state;
    private List<T> updateSteps;

    @Schema(description="The ID of the request", accessMode=Schema.AccessMode.READ_ONLY)
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Schema(description="The URI for the request", accessMode=Schema.AccessMode.READ_ONLY)
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlJavaTypeAdapter(value=TimestampAdapter.class)
    @Schema(description="The timestamp of when the request was submitted", accessMode=Schema.AccessMode.READ_ONLY)
    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(Date submissionTime) {
        this.submissionTime = submissionTime;
    }

    @XmlJavaTypeAdapter(value=TimestampAdapter.class)
    @Schema(description="The timestamp of when the request was last updated", accessMode=Schema.AccessMode.READ_ONLY)
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Schema(description="Whether or not the request is completed", accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Schema(description="The reason for the request failing, or null if the request has not failed", accessMode=Schema.AccessMode.READ_ONLY)
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    @Schema(description="A value between 0 and 100 (inclusive) indicating how close the request is to completion", accessMode=Schema.AccessMode.READ_ONLY)
    public int getPercentCompleted() {
        return this.percentCompleted;
    }

    public void setPercentCompleted(int percentCompleted) {
        this.percentCompleted = percentCompleted;
    }

    @Schema(description="A description of the current state of the request", accessMode=Schema.AccessMode.READ_ONLY)
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Schema(description="The steps that are required in order to complete the request, along with the status of each", accessMode=Schema.AccessMode.READ_ONLY)
    public List<T> getUpdateSteps() {
        return this.updateSteps;
    }

    public void setUpdateSteps(List<T> updateSteps) {
        this.updateSteps = updateSteps;
    }
}

