/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Set;
import org.apache.nifi.web.api.dto.ComponentRestrictionPermissionDTO;
import org.apache.nifi.web.api.dto.PermissionsDTO;
import org.apache.nifi.web.api.entity.Entity;

@XmlRootElement(name="currentEntity")
public class CurrentUserEntity
extends Entity {
    private String identity;
    private boolean anonymous;
    private boolean logoutSupported;
    private PermissionsDTO provenancePermissions;
    private PermissionsDTO countersPermissions;
    private PermissionsDTO tenantsPermissions;
    private PermissionsDTO controllerPermissions;
    private PermissionsDTO policiesPermissions;
    private PermissionsDTO systemPermissions;
    private PermissionsDTO parameterContextPermissions;
    private PermissionsDTO restrictedComponentsPermissions;
    private Set<ComponentRestrictionPermissionDTO> componentRestrictionPermissions;
    private boolean canVersionFlows;

    @Schema(description="The user identity being serialized.")
    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Schema(description="Whether the current user is anonymous.")
    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Schema(description="Whether the system is configured to support logout operations based on current user authentication status", accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isLogoutSupported() {
        return this.logoutSupported;
    }

    public void setLogoutSupported(boolean logoutSupported) {
        this.logoutSupported = logoutSupported;
    }

    @Schema(description="Permissions for querying provenance.")
    public PermissionsDTO getProvenancePermissions() {
        return this.provenancePermissions;
    }

    public void setProvenancePermissions(PermissionsDTO provenancePermissions) {
        this.provenancePermissions = provenancePermissions;
    }

    @Schema(description="Permissions for accessing counters.")
    public PermissionsDTO getCountersPermissions() {
        return this.countersPermissions;
    }

    public void setCountersPermissions(PermissionsDTO countersPermissions) {
        this.countersPermissions = countersPermissions;
    }

    @Schema(description="Permissions for accessing tenants.")
    public PermissionsDTO getTenantsPermissions() {
        return this.tenantsPermissions;
    }

    public void setTenantsPermissions(PermissionsDTO tenantsPermissions) {
        this.tenantsPermissions = tenantsPermissions;
    }

    @Schema(description="Permissions for accessing the controller.")
    public PermissionsDTO getControllerPermissions() {
        return this.controllerPermissions;
    }

    public void setControllerPermissions(PermissionsDTO controllerPermissions) {
        this.controllerPermissions = controllerPermissions;
    }

    @Schema(description="Permissions for accessing the policies.")
    public PermissionsDTO getPoliciesPermissions() {
        return this.policiesPermissions;
    }

    public void setPoliciesPermissions(PermissionsDTO policiesPermissions) {
        this.policiesPermissions = policiesPermissions;
    }

    @Schema(description="Permissions for accessing system.")
    public PermissionsDTO getSystemPermissions() {
        return this.systemPermissions;
    }

    public void setSystemPermissions(PermissionsDTO systemPermissions) {
        this.systemPermissions = systemPermissions;
    }

    @Schema(description="Permissions for accessing parameter contexts.")
    public PermissionsDTO getParameterContextPermissions() {
        return this.parameterContextPermissions;
    }

    public void setParameterContextPermissions(PermissionsDTO parameterContextPermissions) {
        this.parameterContextPermissions = parameterContextPermissions;
    }

    @Schema(description="Permissions for accessing restricted components. Note: the read permission are not used and will always be false.")
    public PermissionsDTO getRestrictedComponentsPermissions() {
        return this.restrictedComponentsPermissions;
    }

    public void setRestrictedComponentsPermissions(PermissionsDTO restrictedComponentsPermissions) {
        this.restrictedComponentsPermissions = restrictedComponentsPermissions;
    }

    @Schema(description="Permissions for specific component restrictions.")
    public Set<ComponentRestrictionPermissionDTO> getComponentRestrictionPermissions() {
        return this.componentRestrictionPermissions;
    }

    public void setComponentRestrictionPermissions(Set<ComponentRestrictionPermissionDTO> componentRestrictionPermissions) {
        this.componentRestrictionPermissions = componentRestrictionPermissions;
    }

    @Schema(description="Whether the current user can version flows.")
    public boolean isCanVersionFlows() {
        return this.canVersionFlows;
    }

    public void setCanVersionFlows(boolean canVersionFlows) {
        this.canVersionFlows = canVersionFlows;
    }
}

