/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import org.springframework.aop.aspectj.annotation.AbstractAspectJAdvisorFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.util.ClassUtils;

class AspectJAdvisorBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private static final boolean aspectjPresent = ClassUtils.isPresent((String)"org.aspectj.lang.annotation.Pointcut", (ClassLoader)AspectJAdvisorBeanRegistrationAotProcessor.class.getClassLoader());

    AspectJAdvisorBeanRegistrationAotProcessor() {
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass;
        if (aspectjPresent && AbstractAspectJAdvisorFactory.compiledByAjc(beanClass = registeredBean.getBeanClass())) {
            return new AspectJAdvisorContribution(beanClass);
        }
        return null;
    }

    private static class AspectJAdvisorContribution
    implements BeanRegistrationAotContribution {
        private final Class<?> beanClass;

        public AspectJAdvisorContribution(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            generationContext.getRuntimeHints().reflection().registerType(this.beanClass, new MemberCategory[]{MemberCategory.DECLARED_FIELDS});
        }
    }
}

