/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Message;
import java.time.Duration;
import java.util.List;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jms.AcknowledgeMode;
import org.springframework.boot.autoconfigure.jms.JmsAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.jms.core.JmsMessageOperations;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;

@AutoConfiguration
@ConditionalOnClass(value={Message.class, JmsTemplate.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={JmsProperties.class})
@Import(value={JmsAnnotationDrivenConfiguration.class})
@ImportRuntimeHints(value={JmsRuntimeHints.class})
public class JmsAutoConfiguration {

    static class JmsRuntimeHints
    implements RuntimeHintsRegistrar {
        JmsRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerType(TypeReference.of(AcknowledgeMode.class), type -> type.withMethod("of", List.of(TypeReference.of(String.class)), ExecutableMode.INVOKE));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JmsMessagingTemplate.class})
    @Import(value={JmsTemplateConfiguration.class})
    protected static class MessagingTemplateConfiguration {
        protected MessagingTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={JmsMessageOperations.class})
        @ConditionalOnSingleCandidate(value=JmsTemplate.class)
        public JmsMessagingTemplate jmsMessagingTemplate(JmsProperties properties, JmsTemplate jmsTemplate) {
            JmsMessagingTemplate messagingTemplate = new JmsMessagingTemplate(jmsTemplate);
            this.mapTemplateProperties(properties.getTemplate(), messagingTemplate);
            return messagingTemplate;
        }

        private void mapTemplateProperties(JmsProperties.Template properties, JmsMessagingTemplate messagingTemplate) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(properties::getDefaultDestination).to(arg_0 -> ((JmsMessagingTemplate)messagingTemplate).setDefaultDestinationName(arg_0));
        }
    }

    @Configuration(proxyBeanMethods=false)
    protected static class JmsTemplateConfiguration {
        private final JmsProperties properties;
        private final ObjectProvider<DestinationResolver> destinationResolver;
        private final ObjectProvider<MessageConverter> messageConverter;

        public JmsTemplateConfiguration(JmsProperties properties, ObjectProvider<DestinationResolver> destinationResolver, ObjectProvider<MessageConverter> messageConverter) {
            this.properties = properties;
            this.destinationResolver = destinationResolver;
            this.messageConverter = messageConverter;
        }

        @Bean
        @ConditionalOnMissingBean(value={JmsOperations.class})
        @ConditionalOnSingleCandidate(value=ConnectionFactory.class)
        public JmsTemplate jmsTemplate(ConnectionFactory connectionFactory) {
            PropertyMapper map = PropertyMapper.get();
            JmsTemplate template = new JmsTemplate(connectionFactory);
            template.setPubSubDomain(this.properties.isPubSubDomain());
            map.from(() -> this.destinationResolver.getIfUnique()).whenNonNull().to(arg_0 -> ((JmsTemplate)template).setDestinationResolver(arg_0));
            map.from(() -> this.messageConverter.getIfUnique()).whenNonNull().to(arg_0 -> ((JmsTemplate)template).setMessageConverter(arg_0));
            this.mapTemplateProperties(this.properties.getTemplate(), template);
            return template;
        }

        private void mapTemplateProperties(JmsProperties.Template properties, JmsTemplate template) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(properties.getSession().getAcknowledgeMode()::getMode).to(arg_0 -> ((JmsTemplate)template).setSessionAcknowledgeMode(arg_0));
            map.from(properties.getSession()::isTransacted).to(arg_0 -> ((JmsTemplate)template).setSessionTransacted(arg_0));
            map.from(properties::getDefaultDestination).whenNonNull().to(arg_0 -> ((JmsTemplate)template).setDefaultDestinationName(arg_0));
            map.from(properties::getDeliveryDelay).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((JmsTemplate)template).setDeliveryDelay(arg_0));
            map.from(properties::determineQosEnabled).to(arg_0 -> ((JmsTemplate)template).setExplicitQosEnabled(arg_0));
            map.from(properties::getDeliveryMode).as(JmsProperties.DeliveryMode::getValue).to(arg_0 -> ((JmsTemplate)template).setDeliveryMode(arg_0));
            map.from(properties::getPriority).whenNonNull().to(arg_0 -> ((JmsTemplate)template).setPriority(arg_0));
            map.from(properties::getTimeToLive).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((JmsTemplate)template).setTimeToLive(arg_0));
            map.from(properties::getReceiveTimeout).as(Duration::toMillis).to(arg_0 -> ((JmsTemplate)template).setReceiveTimeout(arg_0));
        }
    }
}

