/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.batch.BatchHandler;
import org.apache.olingo.odata2.api.batch.BatchRequestPart;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.core.ODataContextImpl;
import org.apache.olingo.odata2.core.ODataPathSegmentImpl;
import org.apache.olingo.odata2.core.ODataRequestHandler;
import org.apache.olingo.odata2.core.PathInfoImpl;

public class BatchHandlerImpl
implements BatchHandler {
    private static final int BAD_REQUEST = 400;
    private ODataServiceFactory factory;
    private ODataService service;
    private Map<String, String> contentIdMap;
    private static final String BATCH_ODATA_REQUEST_HEADERS = "batchODataRequestHeaders";

    public BatchHandlerImpl(ODataServiceFactory factory, ODataService service) {
        this.factory = factory;
        this.service = service;
        this.contentIdMap = new HashMap<String, String>();
    }

    public BatchResponsePart handleBatchPart(BatchRequestPart batchPart) throws ODataException {
        if (batchPart.isChangeSet()) {
            List changeSetRequests = batchPart.getRequests();
            return this.service.getBatchProcessor().executeChangeSet((BatchHandler)this, changeSetRequests);
        }
        if (batchPart.getRequests().size() != 1) {
            throw new ODataException("Query Operation should contain one request");
        }
        ODataRequest request = (ODataRequest)batchPart.getRequests().get(0);
        String mimeHeaderContentId = request.getRequestHeaderValue("MimeHeader-ContentId".toLowerCase(Locale.ENGLISH));
        String requestHeaderContentId = request.getRequestHeaderValue("RequestHeader-ContentId".toLowerCase(Locale.ENGLISH));
        List odataSegments = request.getPathInfo().getODataSegments();
        if (!odataSegments.isEmpty() && ((PathSegment)odataSegments.get(0)).getPath().matches("\\$.*")) {
            request = this.modifyRequest(request, odataSegments);
        }
        ODataRequestHandler handler = this.createHandler(request);
        ODataResponse response = this.setContentIdHeader(request, handler.handle(request), mimeHeaderContentId, requestHeaderContentId);
        ArrayList<ODataResponse> responses = new ArrayList<ODataResponse>(1);
        responses.add(response);
        return BatchResponsePart.responses(responses).changeSet(false).build();
    }

    public ODataResponse handleRequest(ODataRequest suppliedRequest) throws ODataException {
        String mimeHeaderContentId = suppliedRequest.getRequestHeaderValue("MimeHeader-ContentId".toLowerCase(Locale.ENGLISH));
        String requestHeaderContentId = suppliedRequest.getRequestHeaderValue("RequestHeader-ContentId".toLowerCase(Locale.ENGLISH));
        List odataSegments = suppliedRequest.getPathInfo().getODataSegments();
        ODataRequest request = !odataSegments.isEmpty() && ((PathSegment)odataSegments.get(0)).getPath().matches("\\$.*") ? this.modifyRequest(suppliedRequest, odataSegments) : suppliedRequest;
        ODataRequestHandler handler = this.createHandler(request);
        ODataResponse response = handler.handle(request);
        if (response.getStatus().getStatusCode() < 400) {
            response = this.setContentIdHeader(request, response, mimeHeaderContentId, requestHeaderContentId);
        }
        if (request.getMethod().equals((Object)ODataHttpMethod.POST)) {
            String baseUri = this.getBaseUri(request);
            if (mimeHeaderContentId != null) {
                this.fillContentIdMap(response, mimeHeaderContentId, baseUri);
            } else if (requestHeaderContentId != null) {
                this.fillContentIdMap(response, requestHeaderContentId, baseUri);
            }
        }
        return response;
    }

    private void fillContentIdMap(ODataResponse response, String contentId, String baseUri) {
        String location = response.getHeader("Location");
        if (location != null) {
            String relLocation = location.replace(baseUri + "/", "");
            this.contentIdMap.put("$" + contentId, relLocation);
        }
    }

    private ODataRequest modifyRequest(ODataRequest request, List<PathSegment> odataSegments) throws ODataException {
        String contentId = this.contentIdMap.get(odataSegments.get(0).getPath());
        if (contentId == null) {
            return request;
        }
        PathInfoImpl pathInfo = new PathInfoImpl();
        try {
            String[] segments;
            ArrayList<PathSegment> modifiedODataSegments = new ArrayList<PathSegment>();
            for (String segment : segments = contentId.split("/")) {
                modifiedODataSegments.add(new ODataPathSegmentImpl(segment, null));
            }
            Object newRequestUri = this.getBaseUri(request);
            newRequestUri = (String)newRequestUri + "/" + contentId;
            for (int i = 1; i < odataSegments.size(); ++i) {
                newRequestUri = (String)newRequestUri + "/" + odataSegments.get(i).getPath();
                modifiedODataSegments.add(odataSegments.get(i));
            }
            for (Map.Entry entry : request.getQueryParameters().entrySet()) {
                newRequestUri = (String)newRequestUri + "/" + entry;
            }
            pathInfo.setServiceRoot(request.getPathInfo().getServiceRoot());
            pathInfo.setPrecedingPathSegment(request.getPathInfo().getPrecedingSegments());
            pathInfo.setRequestUri(new URI((String)newRequestUri));
            pathInfo.setODataPathSegment(modifiedODataSegments);
        }
        catch (URISyntaxException e) {
            throw new ODataException((Throwable)e);
        }
        ODataRequest modifiedRequest = ODataRequest.fromRequest((ODataRequest)request).pathInfo((PathInfo)pathInfo).build();
        return modifiedRequest;
    }

    private ODataResponse setContentIdHeader(ODataRequest request, ODataResponse response, String mimeHeaderContentId, String requestHeaderContentId) {
        ODataResponse modifiedResponse;
        if (requestHeaderContentId != null && mimeHeaderContentId != null) {
            String baseUri = this.getBaseUri(request);
            this.fillContentIdMap(response, requestHeaderContentId, baseUri);
            this.fillContentIdMap(response, mimeHeaderContentId, baseUri);
            modifiedResponse = ODataResponse.fromResponse((ODataResponse)response).header("RequestHeader-ContentId", requestHeaderContentId).header("MimeHeader-ContentId", mimeHeaderContentId).build();
        } else if (requestHeaderContentId != null) {
            modifiedResponse = ODataResponse.fromResponse((ODataResponse)response).header("RequestHeader-ContentId", requestHeaderContentId).build();
        } else if (mimeHeaderContentId != null) {
            modifiedResponse = ODataResponse.fromResponse((ODataResponse)response).header("MimeHeader-ContentId", mimeHeaderContentId).build();
        } else {
            return response;
        }
        return modifiedResponse;
    }

    private String getBaseUri(ODataRequest request) {
        String baseUri = request.getPathInfo().getServiceRoot().toASCIIString();
        if (baseUri.endsWith("/")) {
            baseUri = baseUri.substring(0, baseUri.length() - 1);
        }
        return baseUri;
    }

    private ODataRequestHandler createHandler(ODataRequest request) throws ODataException {
        ODataContextImpl context = new ODataContextImpl(request, this.factory);
        ODataContext parentContext = this.service.getProcessor().getContext();
        context.setBatchParentContext(parentContext);
        context.setService(this.service);
        if (parentContext != null && parentContext.getParameter(BATCH_ODATA_REQUEST_HEADERS) != null) {
            context.setParameter(BATCH_ODATA_REQUEST_HEADERS, parentContext.getParameter(BATCH_ODATA_REQUEST_HEADERS));
        } else if (parentContext != null && parentContext.getRequestHeaders() != null) {
            context.setParameter(BATCH_ODATA_REQUEST_HEADERS, parentContext.getRequestHeaders());
        }
        this.service.getProcessor().setContext((ODataContext)context);
        return new ODataRequestHandler(this.factory, this.service, context);
    }
}

