/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.core.ep.consumer.JsonFeedConsumer;
import org.apache.olingo.odata2.core.ep.feed.FeedMetadataImpl;

public class JsonLinkConsumer {
    public String readLink(JsonReader reader, EdmEntitySet entitySet) throws EntityProviderException {
        try {
            reader.beginObject();
            String nextName = reader.nextName();
            boolean wrapped = "d".equals(nextName);
            if (wrapped) {
                reader.beginObject();
                nextName = reader.nextName();
            }
            if (!"uri".equals(nextName) || reader.peek() != JsonToken.STRING) {
                throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent(new Object[]{"d or uri"}).addContent(new Object[]{nextName}));
            }
            String result = reader.nextString();
            reader.endObject();
            if (wrapped) {
                reader.endObject();
            }
            reader.peek();
            return result;
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    public List<String> readLinks(JsonReader reader, EdmEntitySet entitySet) throws EntityProviderException {
        List<String> links = null;
        int openedObjects = 0;
        try {
            String nextName;
            if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                nextName = "results";
            } else {
                reader.beginObject();
                ++openedObjects;
                nextName = reader.nextName();
            }
            if ("d".equals(nextName)) {
                if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                    nextName = "results";
                } else {
                    reader.beginObject();
                    ++openedObjects;
                    nextName = reader.nextName();
                }
            }
            FeedMetadataImpl feedMetadata = new FeedMetadataImpl();
            if ("__count".equals(nextName)) {
                JsonFeedConsumer.readInlineCount(reader, feedMetadata);
                nextName = reader.nextName();
            }
            if (!"results".equals(nextName)) {
                throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent(new Object[]{"results"}).addContent(new Object[]{nextName}));
            }
            links = this.readLinksArray(reader);
            if (reader.hasNext() && reader.peek() == JsonToken.NAME) {
                if ("__count".equals(reader.nextName())) {
                    JsonFeedConsumer.readInlineCount(reader, feedMetadata);
                } else {
                    throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent(new Object[]{"__count"}).addContent(new Object[]{nextName}));
                }
            }
            while (openedObjects > 0) {
                reader.endObject();
                --openedObjects;
            }
            reader.peek();
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        return links;
    }

    private List<String> readLinksArray(JsonReader reader) throws IOException, EntityProviderException {
        ArrayList<String> links = new ArrayList<String>();
        reader.beginArray();
        while (reader.hasNext()) {
            reader.beginObject();
            String nextName = reader.nextName();
            if (!"uri".equals(nextName) || reader.peek() != JsonToken.STRING) {
                throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent(new Object[]{"uri"}).addContent(new Object[]{nextName}));
            }
            links.add(reader.nextString());
            reader.endObject();
        }
        reader.endArray();
        return links;
    }
}

