/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Operation;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class JsonPropertyDeserializer
extends JsonDeserializer {
    public JsonPropertyDeserializer(boolean serverMode) {
        super(serverMode);
    }

    protected ResWrap<Property> doDeserialize(JsonParser parser) throws IOException {
        URI contextURL;
        String metadataETag;
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        Property property = new Property();
        if (tree.hasNonNull("@odata.metadataEtag")) {
            metadataETag = tree.get("@odata.metadataEtag").textValue();
            tree.remove("@odata.metadataEtag");
        } else {
            metadataETag = null;
        }
        if (tree.hasNonNull("@odata.context")) {
            contextURL = URI.create(tree.get("@odata.context").textValue());
            property.setName(StringUtils.substringAfterLast((String)contextURL.toASCIIString(), (String)"/"));
            tree.remove("@odata.context");
        } else if (tree.hasNonNull("odata.metadata")) {
            contextURL = URI.create(tree.get("odata.metadata").textValue());
            property.setType(new EdmTypeInfo.Builder().setTypeExpression(StringUtils.substringAfterLast((String)contextURL.toASCIIString(), (String)"#")).build().internal());
            tree.remove("odata.metadata");
        } else {
            contextURL = null;
        }
        if (tree.has("@odata.type")) {
            property.setType(new EdmTypeInfo.Builder().setTypeExpression(tree.get("@odata.type").textValue()).build().internal());
            tree.remove("@odata.type");
        }
        if (tree.has("odata.null") && tree.get("odata.null").asBoolean()) {
            property.setValue(ValueType.PRIMITIVE, null);
            tree.remove("odata.null");
        }
        if (property.getValue() == null) {
            try {
                this.value((Valuable)property, (JsonNode)(tree.has("value") ? tree.get("value") : tree), parser.getCodec());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new IOException(e);
            }
            tree.remove("value");
        }
        HashSet<String> toRemove = new HashSet<String>();
        Iterator itor = tree.fields();
        while (itor.hasNext()) {
            Map.Entry field = (Map.Entry)itor.next();
            if (((String)field.getKey()).charAt(0) == '@') {
                Annotation annotation = new Annotation();
                annotation.setTerm(((String)field.getKey()).substring(1));
                try {
                    this.value((Valuable)annotation, (JsonNode)field.getValue(), parser.getCodec());
                }
                catch (EdmPrimitiveTypeException e) {
                    throw new IOException(e);
                }
                property.getAnnotations().add(annotation);
                continue;
            }
            if (((String)field.getKey()).charAt(0) != '#') continue;
            Operation operation = new Operation();
            operation.setMetadataAnchor((String)field.getKey());
            ObjectNode opNode = (ObjectNode)tree.get((String)field.getKey());
            operation.setTitle(opNode.get("title").asText());
            operation.setTarget(URI.create(opNode.get("target").asText()));
            property.getOperations().add(operation);
            toRemove.add((String)field.getKey());
        }
        tree.remove(toRemove);
        return new ResWrap(contextURL, metadataETag, (Object)property);
    }
}

