/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public class OwbParametrizedTypeImpl
implements ParameterizedType {
    private final Type owner;
    private final Type rawType;
    private final Type[] types;

    public OwbParametrizedTypeImpl(Type owner, Type raw, Type ... types) {
        this.owner = owner;
        this.rawType = raw;
        this.types = types;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.types.clone();
    }

    @Override
    public Type getOwnerType() {
        return this.owner;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public int hashCode() {
        return Arrays.hashCode(this.types) ^ (this.owner == null ? 0 : this.owner.hashCode()) ^ (this.rawType == null ? 0 : this.rawType.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ParameterizedType) {
            ParameterizedType that = (ParameterizedType)obj;
            Type thatOwnerType = that.getOwnerType();
            Type thatRawType = that.getRawType();
            return (this.owner == null ? thatOwnerType == null : this.owner.equals(thatOwnerType)) && (this.rawType == null ? thatRawType == null : this.rawType.equals(thatRawType)) && Arrays.equals(this.types, that.getActualTypeArguments());
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Class)this.rawType).getSimpleName());
        Type[] actualTypes = this.getActualTypeArguments();
        if (actualTypes.length > 0) {
            buffer.append("<");
            int length = actualTypes.length;
            for (int i = 0; i < length; ++i) {
                buffer.append(actualTypes[i].toString());
                if (i == actualTypes.length - 1) continue;
                buffer.append(",");
            }
            buffer.append(">");
        }
        return buffer.toString();
    }
}

