/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.annotation.NamedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.inject.impl.InjectionPointImpl;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;

public class InjectionPointFactory {
    private final WebBeansContext webBeansContext;

    public InjectionPointFactory(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public <X> Set<InjectionPoint> buildInjectionPoints(Bean<X> owner, AnnotatedType<X> annotatedType) {
        HashSet<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
        boolean constructorFound = false;
        for (AnnotatedConstructor constructor : annotatedType.getConstructors()) {
            if (!constructor.isAnnotationPresent(Inject.class)) continue;
            if (constructorFound) {
                throw new WebBeansConfigurationException("There are more than one constructor with @Inject annotation in annotation type : " + annotatedType);
            }
            constructorFound = true;
            this.validateInitializerConstructor(constructor);
            this.buildInjectionPoints(owner, (AnnotatedCallable<X>)constructor, (Collection<InjectionPoint>)injectionPoints);
        }
        for (AnnotatedField field : annotatedType.getFields()) {
            if (owner != null && Modifier.isPublic(field.getJavaMember().getModifiers()) && !field.isStatic() && this.webBeansContext.getBeanManagerImpl().isNormalScope(owner.getScope())) {
                throw new WebBeansConfigurationException("If bean has a public field, bean scope must be defined as @Scope. Bean is : " + owner.getBeanClass().getName());
            }
            if (!field.isAnnotationPresent(Inject.class)) continue;
            injectionPoints.add(this.buildInjectionPoint(owner, field));
        }
        for (AnnotatedMethod method : annotatedType.getMethods()) {
            if (!method.isAnnotationPresent(Inject.class) || Modifier.isStatic(method.getJavaMember().getModifiers())) continue;
            this.validateInitializerMethod(method);
            this.buildInjectionPoints(owner, (AnnotatedCallable<X>)method, (Collection<InjectionPoint>)injectionPoints);
        }
        return injectionPoints;
    }

    public <X> InjectionPoint buildInjectionPoint(Bean<?> owner, AnnotatedField<X> annotField) {
        Asserts.assertNotNull(annotField, "annotField parameter can not be null");
        Annotation[] annots = AnnotationUtil.asArray(annotField.getAnnotations());
        Annotation[] qualifierAnnots = this.webBeansContext.getAnnotationManager().getQualifierAnnotations(annots);
        for (int i = 0; i < qualifierAnnots.length; ++i) {
            Annotation qualifier = qualifierAnnots[i];
            if (!qualifier.annotationType().equals(Named.class)) continue;
            Named named = (Named)qualifier;
            String value = named.value();
            if (value != null && !value.equals("")) break;
            NamedLiteral namedLiteral = new NamedLiteral();
            namedLiteral.setValue(annotField.getJavaMember().getName());
            qualifierAnnots[i] = namedLiteral;
            break;
        }
        return new InjectionPointImpl(owner, Arrays.asList(qualifierAnnots), annotField);
    }

    public <X> InjectionPoint buildInjectionPoint(Bean<?> owner, AnnotatedParameter<X> parameter) {
        Asserts.assertNotNull(parameter, "parameter parameter can not be null");
        Set anns = parameter.getAnnotations();
        Annotation[] qualifierAnnots = this.webBeansContext.getAnnotationManager().getQualifierAnnotations(anns.toArray(new Annotation[anns.size()]));
        return new InjectionPointImpl(owner, Arrays.asList(qualifierAnnots), parameter);
    }

    public <X> List<InjectionPoint> buildInjectionPoints(Bean<?> owner, AnnotatedCallable<X> callable) {
        ArrayList<InjectionPoint> lists = new ArrayList<InjectionPoint>();
        this.buildInjectionPoints(owner, callable, lists);
        return lists;
    }

    private <X> void buildInjectionPoints(Bean<?> owner, AnnotatedCallable<X> callable, Collection<InjectionPoint> lists) {
        Asserts.assertNotNull(callable, "callable parameter can not be null");
        List parameters = callable.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (parameter.getAnnotation(Observes.class) != null) continue;
            lists.add(this.buildInjectionPoint(owner, parameter));
        }
    }

    public static InjectionPoint getPartialInjectionPoint(Bean<?> owner, AnnotatedParameter<?> parameter, Annotation ... bindings) {
        return new InjectionPointImpl(owner, Arrays.asList(bindings), parameter);
    }

    public static InjectionPoint getVirtualInjectionPoint(Bean<?> bean) {
        return new InjectionPointImpl(bean.getBeanClass(), bean.getQualifiers());
    }

    private void validateInitializerConstructor(AnnotatedConstructor<?> constructor) {
        for (AnnotatedParameter parameter : constructor.getParameters()) {
            if (parameter.isAnnotationPresent(Disposes.class)) {
                throw new WebBeansConfigurationException("Constructor parameter annotations can not contain @Disposes annotation in annotated constructor : " + constructor);
            }
            if (!parameter.isAnnotationPresent(Observes.class)) continue;
            throw new WebBeansConfigurationException("Constructor parameter annotations can not contain @Observes annotation in annotated constructor : " + constructor);
        }
    }

    private void validateInitializerMethod(AnnotatedMethod<?> annotatedMethod) {
        Method method = annotatedMethod.getJavaMember();
        TypeVariable<Method>[] args = method.getTypeParameters();
        if (args.length > 0) {
            throw new WebBeansConfigurationException("Error in defining injected methods in annotated method : " + annotatedMethod + ". Reason : Initializer methods must not be generic.");
        }
        if (annotatedMethod.isAnnotationPresent(Produces.class)) {
            throw new WebBeansConfigurationException("Error in defining injected methods in annotated method : " + annotatedMethod + ". Reason : Initializer method can not be annotated with @Produces.");
        }
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        for (AnnotatedParameter annotatedParameter : annotatedMethod.getParameters()) {
            annotationManager.checkForNewQualifierForDeployment(annotatedParameter.getBaseType(), annotatedMethod.getDeclaringType().getJavaClass(), method.getName(), AnnotationUtil.asArray(annotatedParameter.getAnnotations()));
            if (!annotatedParameter.isAnnotationPresent(Disposes.class) && !annotatedParameter.isAnnotationPresent(Observes.class)) continue;
            throw new WebBeansConfigurationException("Error in defining injected methods in annotated method : " + annotatedMethod + ". Reason : Initializer method parameters does not contain @Observes or @Dispose annotations.");
        }
    }
}

