/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.webbeans.config.OwbParametrizedTypeImpl;
import org.apache.webbeans.util.ClassUtil;

public final class GenericsUtil {
    public static boolean satisfiesDependency(boolean isDelegate, Type injectionPointType, Type beanType) {
        Type beanRawType;
        if (beanType instanceof TypeVariable || beanType instanceof WildcardType || beanType instanceof GenericArrayType) {
            return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, beanType);
        }
        Type injectionPointRawType = injectionPointType instanceof ParameterizedType ? ((ParameterizedType)injectionPointType).getRawType() : injectionPointType;
        Type type = beanRawType = beanType instanceof ParameterizedType ? ((ParameterizedType)beanType).getRawType() : beanType;
        if (ClassUtil.isSame(injectionPointRawType, beanRawType)) {
            return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, beanType);
        }
        return false;
    }

    public static boolean isAssignableFrom(boolean isDelegate, Type requiredType, Type beanType) {
        if (requiredType instanceof Class) {
            return GenericsUtil.isAssignableFrom(isDelegate, (Class)requiredType, beanType);
        }
        if (requiredType instanceof ParameterizedType) {
            return GenericsUtil.isAssignableFrom(isDelegate, (ParameterizedType)requiredType, beanType);
        }
        if (requiredType instanceof TypeVariable) {
            return GenericsUtil.isAssignableFrom(isDelegate, (TypeVariable)requiredType, beanType);
        }
        if (requiredType instanceof GenericArrayType) {
            return GenericsUtil.isAssignableFrom(isDelegate, (GenericArrayType)requiredType, beanType);
        }
        if (requiredType instanceof WildcardType) {
            return GenericsUtil.isAssignableFrom(isDelegate, (WildcardType)requiredType, beanType);
        }
        throw new IllegalArgumentException("Unsupported type " + requiredType.getClass());
    }

    private static boolean isAssignableFrom(boolean isDelegate, Class<?> injectionPointType, Type beanType) {
        if (beanType instanceof Class) {
            return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, (Class)beanType);
        }
        if (beanType instanceof TypeVariable) {
            return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, (TypeVariable)beanType);
        }
        if (beanType instanceof ParameterizedType) {
            return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, (ParameterizedType)beanType);
        }
        if (beanType instanceof GenericArrayType) {
            return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, (GenericArrayType)beanType);
        }
        if (beanType instanceof WildcardType) {
            return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, (WildcardType)beanType);
        }
        throw new IllegalArgumentException("Unsupported type " + injectionPointType.getClass());
    }

    private static boolean isAssignableFrom(boolean isDelegate, Class<?> injectionPointType, Class<?> beanType) {
        return ClassUtil.isClassAssignable(injectionPointType, beanType);
    }

    private static boolean isAssignableFrom(boolean isDelegate, Class<?> injectionPointType, TypeVariable<?> beanType) {
        for (Type bounds : beanType.getBounds()) {
            if (!GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, bounds)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(boolean isDelegate, Class<?> injectionPointType, ParameterizedType beanType) {
        if (beanType.getRawType() != injectionPointType) {
            return false;
        }
        for (Type typeArgument : beanType.getActualTypeArguments()) {
            if (typeArgument == Object.class) continue;
            if (!(typeArgument instanceof TypeVariable)) {
                return false;
            }
            TypeVariable typeVariable = (TypeVariable)typeArgument;
            for (Type bounds : typeVariable.getBounds()) {
                if (bounds == Object.class) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isAssignableFrom(boolean isDelegate, Class<?> injectionPointType, GenericArrayType beanType) {
        if (!injectionPointType.isArray()) {
            return false;
        }
        return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType.getComponentType(), beanType.getGenericComponentType());
    }

    private static boolean isAssignableFrom(boolean isDelegate, Type injectionPointType, WildcardType beanType) {
        for (Type bounds : beanType.getLowerBounds()) {
            if (GenericsUtil.isAssignableFrom(isDelegate, bounds, injectionPointType)) continue;
            return false;
        }
        for (Type bounds : beanType.getUpperBounds()) {
            if (!GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, bounds)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(boolean isDelegate, ParameterizedType injectionPointType, Type beanType) {
        if (beanType instanceof Class) {
            return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, (Class)beanType);
        }
        if (beanType instanceof TypeVariable) {
            return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, (TypeVariable)beanType);
        }
        if (beanType instanceof ParameterizedType) {
            return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, (ParameterizedType)beanType);
        }
        if (beanType instanceof WildcardType) {
            return GenericsUtil.isAssignableFrom(isDelegate, (Type)injectionPointType, (WildcardType)beanType);
        }
        if (beanType instanceof GenericArrayType) {
            return false;
        }
        throw new IllegalArgumentException("Unsupported type " + injectionPointType.getClass());
    }

    private static boolean isAssignableFrom(boolean isDelegate, ParameterizedType injectionPointType, Class<?> beanType) {
        return GenericsUtil.isAssignableFrom(isDelegate, injectionPointType.getRawType(), beanType);
    }

    private static boolean isAssignableFrom(boolean isDelegate, ParameterizedType injectionPointType, TypeVariable<?> beanType) {
        for (Type bounds : beanType.getBounds()) {
            if (!GenericsUtil.isAssignableFrom(isDelegate, injectionPointType, bounds)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(boolean isDelegate, ParameterizedType injectionPointType, ParameterizedType beanType) {
        if (injectionPointType.getRawType() != beanType.getRawType()) {
            return false;
        }
        Type[] injectionPointTypeArguments = injectionPointType.getActualTypeArguments();
        Type[] beanTypeArguments = beanType.getActualTypeArguments();
        for (int i = 0; i < injectionPointTypeArguments.length; ++i) {
            Type injectionPointTypeArgument = injectionPointTypeArguments[i];
            Type beanTypeArgument = beanTypeArguments[i];
            if (!isDelegate && injectionPointTypeArgument instanceof Class && beanTypeArgument instanceof TypeVariable) {
                for (Type upperBound : ((TypeVariable)beanTypeArgument).getBounds()) {
                    if (GenericsUtil.isAssignableFrom(isDelegate, upperBound, injectionPointTypeArgument)) continue;
                    return false;
                }
                continue;
            }
            if (GenericsUtil.isAssignableFrom(isDelegate, injectionPointTypeArgument, beanTypeArgument)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableFrom(boolean isDelegate, TypeVariable<?> injectionPointType, Type beanType) {
        for (Type bounds : injectionPointType.getBounds()) {
            if (GenericsUtil.isAssignableFrom(isDelegate, bounds, beanType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableFrom(boolean isDelegate, GenericArrayType injectionPointType, Type beanType) {
        throw new UnsupportedOperationException("Not yet implementeds");
    }

    private static boolean isAssignableFrom(boolean isDelegate, WildcardType injectionPointType, Type beanType) {
        for (Type bounds : injectionPointType.getLowerBounds()) {
            if (GenericsUtil.isAssignableFrom(isDelegate, beanType, bounds)) continue;
            return false;
        }
        for (Type bounds : injectionPointType.getUpperBounds()) {
            if (GenericsUtil.isAssignableFrom(isDelegate, bounds, beanType)) continue;
            return false;
        }
        return true;
    }

    public static Type resolveType(Class<?> subclass, Field field) {
        return GenericsUtil.resolveType(field.getGenericType(), new TypeVariableResolver(subclass, field.getDeclaringClass()));
    }

    public static Type resolveReturnType(Class<?> subclass, Method method) {
        return GenericsUtil.resolveType(method.getGenericReturnType(), new TypeVariableResolver(subclass, method.getDeclaringClass()));
    }

    public static Type[] resolveParameterTypes(Class<?> subclass, Constructor<?> constructor) {
        return GenericsUtil.resolveTypes(constructor.getGenericParameterTypes(), new TypeVariableResolver(subclass, constructor.getDeclaringClass()));
    }

    public static Type[] resolveParameterTypes(Class<?> subclass, Method method) {
        return GenericsUtil.resolveTypes(method.getGenericParameterTypes(), new TypeVariableResolver(subclass, method.getDeclaringClass()));
    }

    public static Type resolveType(Type type, Class<?> subclass, Member member) {
        return GenericsUtil.resolveType(type, new TypeVariableResolver(subclass, member.getDeclaringClass()));
    }

    private static Type resolveType(Type type, TypeVariableResolver resolver) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] resolvedTypes = GenericsUtil.resolveTypes(parameterizedType.getActualTypeArguments(), resolver);
            return new OwbParametrizedTypeImpl(parameterizedType.getOwnerType(), parameterizedType.getRawType(), resolvedTypes);
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            return resolver.resolve(variable);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length > 0) {
                return type;
            }
            Type[] resolvedTypes = GenericsUtil.resolveTypes(wildcardType.getUpperBounds(), resolver);
            return GenericsUtil.resolveType(GenericsUtil.getMostSpecificType(GenericsUtil.getRawTypes(resolvedTypes, resolver), resolvedTypes), resolver);
        }
        if (type instanceof GenericArrayType) {
            Type componentType = GenericsUtil.resolveType(((GenericArrayType)type).getGenericComponentType(), resolver);
            Class componentClass = GenericsUtil.getRawType(componentType, resolver);
            return Array.newInstance(componentClass, 0).getClass();
        }
        throw new IllegalArgumentException("Unsupported type " + type.getClass().getName());
    }

    public static Type[] resolveTypes(Type[] types, TypeVariableResolver resolution) {
        Type[] resolvedTypeArguments = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolvedTypeArguments[i] = GenericsUtil.resolveType(types[i], resolution);
        }
        return resolvedTypeArguments;
    }

    public static Set<Type> getTypeClosure(Type type, Class<?> owningClass, Class<?> declaringClass) {
        HashSet<Type> typeClosure = new HashSet<Type>();
        typeClosure.add((Type)((Object)Object.class));
        GenericsUtil.fillTypeHierarchy(typeClosure, type, new TypeVariableResolver(owningClass, declaringClass));
        return typeClosure;
    }

    private static void fillTypeHierarchy(Set<Type> set, Type type, TypeVariableResolver resolver) {
        if (type == null) {
            return;
        }
        Type resolvedType = GenericsUtil.resolveType(type, resolver);
        set.add(resolvedType);
        Class resolvedClass = GenericsUtil.getRawType(resolvedType, resolver);
        if (resolvedClass.getSuperclass() != null) {
            GenericsUtil.fillTypeHierarchy(set, resolvedClass.getGenericSuperclass(), resolver.add(resolvedClass));
        }
        for (Type interfaceType : resolvedClass.getGenericInterfaces()) {
            GenericsUtil.fillTypeHierarchy(set, interfaceType, resolver.add(resolvedClass, interfaceType));
        }
    }

    static <T> Class<T> getRawType(Type type, TypeVariableResolver resolver) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return GenericsUtil.getRawType(((ParameterizedType)type).getRawType(), resolver);
        }
        if (type instanceof TypeVariable || type instanceof WildcardType || type instanceof GenericArrayType) {
            Type resolvedType = GenericsUtil.resolveType(type, resolver);
            if (resolvedType instanceof TypeVariable) {
                TypeVariable variable = (TypeVariable)resolvedType;
                return GenericsUtil.getRawType(GenericsUtil.resolveType(GenericsUtil.getRawType(variable.getBounds(), resolver), resolver), resolver);
            }
            return GenericsUtil.getRawType(resolvedType, resolver);
        }
        throw new IllegalArgumentException("Unsupported type " + type.getClass().getName());
    }

    private static Type getRawType(Type[] types, TypeVariableResolver resolver) {
        Class<T>[] rawTypes = GenericsUtil.getRawTypes(types, resolver);
        Class<?>[] classTypes = GenericsUtil.getClassTypes(rawTypes);
        if (classTypes.length > 0) {
            return GenericsUtil.getMostSpecificType(classTypes, types);
        }
        return GenericsUtil.getMostSpecificType(rawTypes, types);
    }

    private static <T> Class<T>[] getRawTypes(Type[] types, TypeVariableResolver resolver) {
        Class[] rawTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            rawTypes[i] = GenericsUtil.getRawType(types[i], resolver);
        }
        return rawTypes;
    }

    private static Type getMostSpecificType(Class<?>[] types, Type[] genericTypes) {
        Class<?> mostSpecificType = types[0];
        int mostSpecificIndex = 0;
        for (int i = 0; i < types.length; ++i) {
            if (!mostSpecificType.isAssignableFrom(types[i])) continue;
            mostSpecificType = types[i];
            mostSpecificIndex = i;
        }
        return genericTypes[mostSpecificIndex];
    }

    private static Class<?>[] getClassTypes(Class<?>[] rawTypes) {
        ArrayList classTypes = new ArrayList();
        for (Class<?> rawType : rawTypes) {
            if (rawType.isInterface()) continue;
            classTypes.add(rawType);
        }
        return classTypes.toArray(new Class[classTypes.size()]);
    }

    private static class TypeErasureException
    extends Exception {
        public TypeErasureException() {
            super("generic type information not available");
        }
    }

    private static class TypeVariableDeclaration {
        private Class<?> declaringClass;
        private Type assignment;

        public TypeVariableDeclaration(Class<?> declaringClass, Type assignment) {
            this.declaringClass = declaringClass;
            this.assignment = assignment;
        }

        public Type getAssignment() {
            return this.assignment;
        }

        public TypeVariable<?>[] getDeclaredTypeParameters() {
            return this.declaringClass.getTypeParameters();
        }
    }

    private static class TypeVariableResolver {
        private List<TypeVariableDeclaration> declarations = new ArrayList<TypeVariableDeclaration>();

        private TypeVariableResolver(List<TypeVariableDeclaration> implementation) {
            this.declarations = implementation;
        }

        public TypeVariableResolver(Class<?> subclass, Class<?> declaringClass) {
            this.declarations.add(new TypeVariableDeclaration(subclass, subclass.getGenericSuperclass()));
            while (declaringClass != subclass && declaringClass.isAssignableFrom(subclass)) {
                subclass = subclass.getSuperclass();
                this.declarations.add(new TypeVariableDeclaration(subclass, subclass.getGenericSuperclass()));
            }
        }

        public Type resolve(TypeVariable<?> variable) {
            if (this.declarations.size() < 2) {
                return variable;
            }
            int hierarchyIndex = this.declarations.size() - 1;
            TypeVariableDeclaration typeVariableImplementation = this.declarations.get(hierarchyIndex);
            TypeVariable<?>[] typeParameters = typeVariableImplementation.getDeclaredTypeParameters();
            int typeIndex = -1;
            for (int i = 0; i < typeParameters.length; ++i) {
                if (!variable.getName().equals(typeParameters[i].getName())) continue;
                typeIndex = i;
                break;
            }
            if (typeIndex == -1) {
                return Object.class;
            }
            TypeVariableDeclaration declaration = this.declarations.get(hierarchyIndex - 1);
            Type genericClass = declaration.getAssignment();
            if (genericClass instanceof ParameterizedType) {
                ParameterizedType classType = (ParameterizedType)genericClass;
                Type[] actualTypeArguments = classType.getActualTypeArguments();
                if (actualTypeArguments.length > typeIndex) {
                    return GenericsUtil.resolveType(actualTypeArguments[typeIndex], this.remove());
                }
                return Object.class;
            }
            TypeVariable<?>[] typeVariables = declaration.getDeclaredTypeParameters();
            if (typeVariables.length > typeIndex) {
                return GenericsUtil.resolveType(typeVariables[typeIndex], this.remove());
            }
            return Object.class;
        }

        public TypeVariableResolver add(Class<?> type) {
            return this.add(type, type.getGenericSuperclass());
        }

        public TypeVariableResolver add(Class<?> declaringClass, Type assignment) {
            ArrayList<TypeVariableDeclaration> declarations = new ArrayList<TypeVariableDeclaration>(this.declarations);
            declarations.add(new TypeVariableDeclaration(declaringClass, assignment));
            return new TypeVariableResolver(declarations);
        }

        public TypeVariableResolver remove() {
            ArrayList<TypeVariableDeclaration> declarations = new ArrayList<TypeVariableDeclaration>(this.declarations);
            declarations.remove(declarations.size() - 1);
            return new TypeVariableResolver(declarations);
        }
    }
}

