/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.tomcat7;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.servlet.WebBeansConfigurationListener;
import org.apache.webbeans.web.tomcat7.TomcatInstanceManager;
import org.apache.webbeans.web.tomcat7.TomcatSecurityFilter;

public class ContextLifecycleListener
implements LifecycleListener,
ServletContextAttributeListener {
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            if (event.getSource() instanceof StandardContext) {
                ServletContext scontext;
                URL url;
                StandardContext context = (StandardContext)event.getSource();
                if (event.getType().equals("configure_start") && (url = this.getBeansXml(scontext = context.getServletContext())) != null) {
                    System.setProperty("org.apache.webbeans.application.jsp", "true");
                    this.addOwbListeners(context);
                    this.addOwbFilters(context);
                    context.addApplicationListener(TomcatSecurityFilter.class.getName());
                    context.addApplicationEventListener((Object)this);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addOwbListeners(StandardContext context) {
        String[] oldListeners = context.findApplicationListeners();
        LinkedList<String> listeners = new LinkedList<String>();
        listeners.addFirst(WebBeansConfigurationListener.class.getName());
        for (String listener : oldListeners) {
            listeners.add(listener);
            context.removeApplicationListener(listener);
        }
        for (String listener : listeners) {
            context.addApplicationListener(listener);
        }
    }

    private void addOwbFilters(StandardContext context) {
    }

    private URL getBeansXml(ServletContext scontext) throws MalformedURLException {
        URL url = scontext.getResource("/WEB-INF/beans.xml");
        if (url == null) {
            url = scontext.getResource("/WEB-INF/classes/META-INF/beans.xml");
        }
        return url;
    }

    private void wrapInstanceManager(StandardContext context) {
        if (context.getInstanceManager() instanceof TomcatInstanceManager) {
            return;
        }
        InstanceManager processor = context.getInstanceManager();
        TomcatInstanceManager custom = new TomcatInstanceManager(context.getLoader().getClassLoader(), processor);
        context.setInstanceManager((InstanceManager)custom);
        context.getServletContext().setAttribute(InstanceManager.class.getName(), (Object)custom);
    }

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (InstanceManager.class.getName().equals(servletContextAttributeEvent.getName())) {
            try {
                StandardContext context = (StandardContext)ContextLifecycleListener.getContext(servletContextAttributeEvent.getServletContext());
                this.wrapInstanceManager(context);
            }
            catch (NoSuchFieldException e) {
                throw new WebBeansException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new WebBeansException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getContext(Object o) throws NoSuchFieldException, IllegalAccessException {
        Field getContext = o.getClass().getDeclaredField("context");
        boolean acc = getContext.isAccessible();
        getContext.setAccessible(true);
        try {
            Object retVal = getContext.get(o);
            if (!(retVal instanceof StandardContext)) {
                retVal = ContextLifecycleListener.getContext(retVal);
            }
            Object object = retVal;
            return object;
        }
        finally {
            getContext.setAccessible(acc);
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
    }
}

