/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.lifecycle;

import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.webbeans.config.BeansDeployer;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectableBeanManager;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.WebBeansUtil;

public abstract class AbstractLifeCycle
implements ContainerLifecycle {
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected Logger logger;
    protected ScannerService scannerService;
    protected final ContextsService contextsService;
    private final BeansDeployer deployer;
    private final JNDIService jndiService;
    private final BeanManagerImpl beanManager;
    protected final WebBeansContext webBeansContext;

    protected AbstractLifeCycle() {
        this(null);
    }

    protected AbstractLifeCycle(Properties properties) {
        this(properties, WebBeansContext.getInstance());
    }

    protected AbstractLifeCycle(Properties properties, WebBeansContext webBeansContext) {
        this.beforeInitApplication(properties);
        this.webBeansContext = webBeansContext;
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
        this.deployer = new BeansDeployer(webBeansContext);
        this.jndiService = this.webBeansContext.getService(JNDIService.class);
        this.scannerService = this.webBeansContext.getScannerService();
        this.contextsService = this.webBeansContext.getService(ContextsService.class);
        this.initApplication(properties);
    }

    public WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    public BeanManager getBeanManager() {
        return new InjectableBeanManager(this.beanManager);
    }

    public void startApplication(Object startupObject) {
        this.bootstrapApplication(startupObject);
    }

    protected synchronized void bootstrapApplication(Object startupObject) {
        if (this.started.get()) {
            return;
        }
        this.logger.info("INFO_0005");
        long begin = System.currentTimeMillis();
        this.beforeStartApplication(startupObject);
        this.webBeansContext.getPluginLoader().startUp();
        this.contextsService.init(startupObject);
        this.logger.fine("Scanning classpaths for beans artifacts.");
        this.scannerService.scan();
        this.logger.fine("Deploying scanned beans.");
        this.deployer.deploy(this.scannerService);
        this.afterStartApplication(startupObject);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "INFO_0001", Long.toString(System.currentTimeMillis() - begin));
        }
        this.started.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopApplication(Object endObject) {
        this.logger.fine("OpenWebBeans Container is stopping.");
        try {
            this.beforeStopApplication(endObject);
            this.beanManager.fireLifecycleEvent(new BeforeShutdownImpl(), new Annotation[0]);
            this.contextsService.destroy(endObject);
            this.jndiService.unbind("java:comp/BeanManager");
            this.webBeansContext.getPluginLoader().shutDown();
            this.webBeansContext.getExtensionLoader().clear();
            this.afterStopApplication(endObject);
            this.beanManager.clear();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "ERROR_0021", e);
            }
        }
        finally {
            this.started.set(false);
            WebBeansFinder.clearInstances(WebBeansUtil.getCurrentClassLoader());
        }
    }

    public ContextsService getContextService() {
        return this.contextsService;
    }

    public void initApplication(Properties properties) {
        this.afterInitApplication(properties);
    }

    protected void beforeInitApplication(Properties properties) {
    }

    protected void afterInitApplication(Properties properties) {
    }

    protected void afterStartApplication(Object startupObject) {
    }

    protected void afterStopApplication(Object stopObject) {
    }

    protected void beforeStartApplication(Object startupObject) {
    }

    protected void beforeStopApplication(Object stopObject) {
    }
}

