/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.fontbox.cff.CFFFont;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.preflight.font.container.FontContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIDType0Container
extends FontContainer {
    protected List<CFFFont> lCFonts = new ArrayList<CFFFont>();

    public CIDType0Container(PDFont font) {
        super(font);
    }

    @Override
    protected float getFontProgramWidth(int cid) {
        boolean cidFound = false;
        for (CFFFont font : this.lCFonts) {
            Collection<CFFFont.Mapping> cMapping = font.getMappings();
            Iterator<CFFFont.Mapping> iterator = cMapping.iterator();
            while (iterator.hasNext()) {
                CFFFont.Mapping mapping = iterator.next();
                if (mapping.getSID() != cid) continue;
                cidFound = true;
                break;
            }
            if (!cidFound) continue;
            break;
        }
        float widthInFontProgram = 0.0f;
        if (cidFound || cid == 0) {
            float defaultGlyphWidth = 0.0f;
            if (this.font.getFontDescriptor() != null) {
                defaultGlyphWidth = this.font.getFontDescriptor().getMissingWidth();
            }
            try {
                for (CFFFont cff : this.lCFonts) {
                    widthInFontProgram = cff.getWidth(cid);
                    if (widthInFontProgram == defaultGlyphWidth) continue;
                }
            }
            catch (IOException e) {
                widthInFontProgram = -1.0f;
            }
        } else {
            widthInFontProgram = -1.0f;
        }
        return widthInFontProgram;
    }

    public void setlCFonts(List<CFFFont> lCFonts) {
        this.lCFonts = lCFonts;
    }
}

