/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.NativeMemory;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.QuickSelect;
import com.yahoo.sketches.Util;

final class Rebuilder {
    private Rebuilder() {
    }

    static final void quickSelectAndRebuild(Memory mem, int preambleLongs, int lgNomLongs, int lgArrLongs, int curCount) {
        int arrLongs = 1 << lgArrLongs;
        long[] tmpArr = new long[arrLongs];
        int preBytes = preambleLongs << 3;
        mem.getLongArray((long)preBytes, tmpArr, 0, arrLongs);
        int pivot = (1 << lgNomLongs) + 1;
        long newThetaLong = QuickSelect.selectExcludingZeros(tmpArr, curCount, pivot);
        mem.putLong(16L, newThetaLong);
        long[] tgtArr = new long[arrLongs];
        int newCurCount = HashOperations.hashArrayInsert(tmpArr, tgtArr, lgArrLongs, newThetaLong);
        mem.putInt(8L, newCurCount);
        mem.putLongArray((long)preBytes, tgtArr, 0, arrLongs);
    }

    static final void moveAndResize(Memory srcMem, int preambleLongs, int srcLgArrLongs, Memory dstMem, int dstLgArrLongs, long thetaLong) {
        int preBytes = preambleLongs << 3;
        NativeMemory.copy((Memory)srcMem, (long)0L, (Memory)dstMem, (long)0L, (long)preBytes);
        int srcHTLen = 1 << srcLgArrLongs;
        long[] srcHTArr = new long[srcHTLen];
        srcMem.getLongArray((long)preBytes, srcHTArr, 0, srcHTLen);
        int dstHTLen = 1 << dstLgArrLongs;
        long[] dstHTArr = new long[dstHTLen];
        HashOperations.hashArrayInsert(srcHTArr, dstHTArr, dstLgArrLongs, thetaLong);
        dstMem.putLongArray((long)preBytes, dstHTArr, 0, dstHTLen);
        dstMem.putByte(4L, (byte)dstLgArrLongs);
    }

    static final void resize(Memory mem, int preambleLongs, int srcLgArrLongs, int dstLgArrLongs) {
        int preBytes = preambleLongs << 3;
        int srcHTLen = 1 << srcLgArrLongs;
        long[] srcHTArr = new long[srcHTLen];
        mem.getLongArray((long)preBytes, srcHTArr, 0, srcHTLen);
        int dstHTLen = 1 << dstLgArrLongs;
        long[] dstHTArr = new long[dstHTLen];
        long thetaLong = mem.getLong(16L);
        HashOperations.hashArrayInsert(srcHTArr, dstHTArr, dstLgArrLongs, thetaLong);
        mem.putLongArray((long)preBytes, dstHTArr, 0, dstHTLen);
        mem.putByte(4L, (byte)dstLgArrLongs);
    }

    static final int actLgResizeFactor(long capBytes, int lgArrLongs, int preLongs, int lgRF) {
        int maxHTLongs = Util.floorPowerOf2((int)(capBytes >> 3) - preLongs);
        int lgFactor = Math.max(Integer.numberOfTrailingZeros(maxHTLongs) - lgArrLongs, 0);
        return lgFactor >= lgRF ? lgRF : lgFactor;
    }
}

