/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.topics;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.re2j.Pattern;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.topics.TopicsPattern;
import org.apache.pulsar.common.topics.TopicsPatternFactory;

public final class TopicList {
    public static final String ALL_TOPICS_PATTERN = ".*";
    private static final String SCHEME_SEPARATOR = "://";
    private static final Pattern SCHEME_SEPARATOR_PATTERN = Pattern.compile((String)Pattern.quote((String)"://"));

    public static List<String> filterTopics(List<String> original, java.util.regex.Pattern jdkPattern) {
        return TopicList.filterTopics(original, TopicsPatternFactory.create(jdkPattern));
    }

    public static List<String> filterTopics(List<String> original, String regex, TopicsPattern.RegexImplementation topicsPatternImplementation) {
        return TopicList.filterTopics(original, TopicsPatternFactory.create(regex, topicsPatternImplementation));
    }

    public static List<String> filterTopics(List<String> original, TopicsPattern topicsPattern) {
        return original.stream().map(TopicName::get).filter(topicName -> {
            String partitionedTopicName = topicName.getPartitionedTopicName();
            String removedScheme = SCHEME_SEPARATOR_PATTERN.split(partitionedTopicName)[1];
            return topicsPattern.matches(removedScheme);
        }).map(TopicName::toString).collect(Collectors.toList());
    }

    public static List<String> filterSystemTopic(List<String> original) {
        return original.stream().filter(topic -> !SystemTopicNames.isSystemTopic(TopicName.get(topic))).collect(Collectors.toList());
    }

    public static String calculateHash(List<String> topics) {
        Hasher hasher = Hashing.crc32c().newHasher();
        Object[] sortedTopics = topics.toArray(new String[topics.size()]);
        Arrays.sort(sortedTopics);
        for (int i = 0; i < sortedTopics.length; ++i) {
            hasher.putString((CharSequence)sortedTopics[i], StandardCharsets.UTF_8);
            if (i >= sortedTopics.length - 1) continue;
            hasher.putByte((byte)44);
        }
        return hasher.hash().toString();
    }

    public static Set<String> minus(Collection<String> list1, Collection<String> list2) {
        HashSet<String> s1 = new HashSet<String>(list1);
        s1.removeAll(list2);
        return s1;
    }

    public static String removeTopicDomainScheme(String originalRegexp) {
        if (!originalRegexp.toString().contains(SCHEME_SEPARATOR)) {
            return originalRegexp;
        }
        String[] parts = SCHEME_SEPARATOR_PATTERN.split(originalRegexp.toString());
        String prefix = parts[0];
        String removedTopicDomain = parts[1];
        if (prefix.equals(TopicDomain.persistent.value()) || prefix.equals(TopicDomain.non_persistent.value())) {
            prefix = "";
        } else if (prefix.endsWith(TopicDomain.non_persistent.value())) {
            prefix = prefix.substring(0, prefix.length() - TopicDomain.non_persistent.value().length());
        } else if (prefix.endsWith(TopicDomain.persistent.value())) {
            prefix = prefix.substring(0, prefix.length() - TopicDomain.persistent.value().length());
        } else {
            throw new IllegalArgumentException("Does not support topic domain: " + prefix);
        }
        return prefix + removedTopicDomain;
    }

    @Generated
    private TopicList() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

