/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations about resource quotas"})
public class CmdResourceQuotas
extends CmdBase {
    public CmdResourceQuotas(Supplier<PulsarAdmin> admin) {
        super("resource-quotas", admin);
        this.addCommand("get", new GetResourceQuota());
        this.addCommand("set", new SetResourceQuota());
        this.addCommand("reset-namespace-bundle-quota", new ResetNamespaceBundleResourceQuota());
    }

    @CommandLine.Command(description={"Get the resource quota for specified namespace bundle, or default quota if no namespace/bundle specified."})
    private class GetResourceQuota
    extends CliCommand {
        @CommandLine.Option(names={"--namespace", "-n"}, description={"tenant/namespace, must be specified together with '--bundle'"})
        private String namespaceName;
        @CommandLine.Option(names={"--bundle", "-b"}, description={"{start-boundary}_{end-boundary}, must be specified together with '--namespace'"})
        private String bundle;

        private GetResourceQuota() {
        }

        @Override
        void run() throws PulsarAdminException, CliCommand.ParameterException {
            if (this.bundle == null && this.namespaceName == null) {
                this.print(CmdResourceQuotas.this.getAdmin().resourceQuotas().getDefaultResourceQuota());
            } else if (this.bundle != null && this.namespaceName != null) {
                String namespace = GetResourceQuota.validateNamespace(this.namespaceName);
                this.print(CmdResourceQuotas.this.getAdmin().resourceQuotas().getNamespaceBundleResourceQuota(namespace, this.bundle));
            } else {
                throw new CliCommand.ParameterException("namespace and bundle must be provided together.");
            }
        }
    }

    @CommandLine.Command(description={"Set the resource quota for specified namespace bundle, or default quota if no namespace/bundle specified."})
    private class SetResourceQuota
    extends CliCommand {
        @CommandLine.Option(names={"--namespace", "-n"}, description={"tenant/namespace, must be specified together with '--bundle'"})
        private String namespaceName;
        @CommandLine.Option(names={"--bundle", "-b"}, description={"{start-boundary}_{end-boundary}, must be specified together with '--namespace'"})
        private String bundle;
        @CommandLine.Option(names={"--msgRateIn", "-mi"}, description={"expected incoming messages per second"}, required=true)
        private long msgRateIn = 0L;
        @CommandLine.Option(names={"--msgRateOut", "-mo"}, description={"expected outgoing messages per second"}, required=true)
        private long msgRateOut = 0L;
        @CommandLine.Option(names={"--bandwidthIn", "-bi"}, description={"expected inbound bandwidth (bytes/second)"}, required=true)
        private long bandwidthIn = 0L;
        @CommandLine.Option(names={"--bandwidthOut", "-bo"}, description={"expected outbound bandwidth (bytes/second)"}, required=true)
        private long bandwidthOut = 0L;
        @CommandLine.Option(names={"--memory", "-mem"}, description={"expected memory usage (Mbytes)"}, required=true)
        private long memory = 0L;
        @CommandLine.Option(names={"--dynamic", "-d"}, description={"dynamic (allow to be dynamically re-calculated) or not"})
        private boolean dynamic = false;

        private SetResourceQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            ResourceQuota quota = new ResourceQuota();
            quota.setMsgRateIn((double)this.msgRateIn);
            quota.setMsgRateOut((double)this.msgRateOut);
            quota.setBandwidthIn((double)this.bandwidthIn);
            quota.setBandwidthOut((double)this.bandwidthOut);
            quota.setMemory((double)this.memory);
            quota.setDynamic(this.dynamic);
            if (this.bundle == null && this.namespaceName == null) {
                CmdResourceQuotas.this.getAdmin().resourceQuotas().setDefaultResourceQuota(quota);
            } else if (this.bundle != null && this.namespaceName != null) {
                String namespace = SetResourceQuota.validateNamespace(this.namespaceName);
                CmdResourceQuotas.this.getAdmin().resourceQuotas().setNamespaceBundleResourceQuota(namespace, this.bundle, quota);
            } else {
                throw new CliCommand.ParameterException("namespace and bundle must be provided together.");
            }
        }
    }

    @CommandLine.Command(description={"Reset the specified namespace bundle's resource quota to default value."})
    private class ResetNamespaceBundleResourceQuota
    extends CliCommand {
        @CommandLine.Option(names={"--namespace", "-n"}, description={"tenant/namespace"}, required=true)
        private String namespaceName;
        @CommandLine.Option(names={"--bundle", "-b"}, description={"{start-boundary}_{end-boundary}"}, required=true)
        private String bundle;

        private ResetNamespaceBundleResourceQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = ResetNamespaceBundleResourceQuota.validateNamespace(this.namespaceName);
            CmdResourceQuotas.this.getAdmin().resourceQuotas().resetNamespaceBundleResourceQuota(namespace, this.bundle);
        }
    }
}

