/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.List;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ConsumerGroupEvent;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;

public class DefaultConsumerIdsChangeListener
implements ConsumerIdsChangeListener {
    private final BrokerController brokerController;

    public DefaultConsumerIdsChangeListener(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    @Override
    public void handle(ConsumerGroupEvent event, String group, Object ... args) {
        if (event == null) {
            return;
        }
        switch (event) {
            case CHANGE: {
                if (args == null || args.length < 1) {
                    return;
                }
                List channels = (List)args[0];
                if (channels == null || !this.brokerController.getBrokerConfig().isNotifyConsumerIdsChangedEnable()) break;
                for (Channel chl : channels) {
                    this.brokerController.getBroker2Client().notifyConsumerIdsChanged(chl, group);
                }
                break;
            }
            case UNREGISTER: {
                this.brokerController.getConsumerFilterManager().unRegister(group);
                break;
            }
            case REGISTER: {
                if (args == null || args.length < 1) {
                    return;
                }
                Collection subscriptionDataList = (Collection)args[0];
                this.brokerController.getConsumerFilterManager().register(group, subscriptionDataList);
                break;
            }
            default: {
                throw new RuntimeException("Unknown event " + (Object)((Object)event));
            }
        }
    }
}

