/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceProvider.class);
    private static ClassLoader thisClassLoader = ServiceProvider.getClassLoader(ServiceProvider.class);
    public static final String TRANSACTION_SERVICE_ID = "META-INF/service/org.apache.rocketmq.broker.transaction.TransactionalMessageService";
    public static final String TRANSACTION_LISTENER_ID = "META-INF/service/org.apache.rocketmq.broker.transaction.AbstractTransactionalMessageCheckListener";
    public static final String RPC_HOOK_ID = "META-INF/service/org.apache.rocketmq.remoting.RPCHook";
    public static final String ACL_VALIDATOR_ID = "META-INF/service/org.apache.rocketmq.acl.AccessValidator";

    protected static String objectId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(o);
    }

    protected static ClassLoader getClassLoader(Class<?> clazz) {
        try {
            return clazz.getClassLoader();
        }
        catch (SecurityException e) {
            LOG.error("Unable to get classloader for class {} due to security restrictions , error info {}", clazz, (Object)e.getMessage());
            throw e;
        }
    }

    protected static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return classLoader;
    }

    protected static InputStream getResourceAsStream(ClassLoader loader, String name) {
        if (loader != null) {
            return loader.getResourceAsStream(name);
        }
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public static <T> List<T> load(String name, Class<?> clazz) {
        LOG.info("Looking for a resource file of name [{}] ...", (Object)name);
        ArrayList<T> services = new ArrayList<T>();
        try {
            ArrayList<String> names = new ArrayList<String>();
            InputStream is = ServiceProvider.getResourceAsStream(ServiceProvider.getContextClassLoader(), name);
            if (is != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                String serviceName = reader.readLine();
                while (serviceName != null && !"".equals(serviceName)) {
                    LOG.info("Creating an instance as specified by file {} which was present in the path of the context classloader.", (Object)name);
                    if (!names.contains(serviceName)) {
                        names.add(serviceName);
                    }
                    services.add(ServiceProvider.initService(ServiceProvider.getContextClassLoader(), serviceName, clazz));
                    serviceName = reader.readLine();
                }
                reader.close();
            } else {
                LOG.warn("No resource file with name [{}] found.", (Object)name);
            }
        }
        catch (Exception e) {
            LOG.error("Error occured when looking for resource file " + name, (Throwable)e);
        }
        return services;
    }

    public static <T> T loadClass(String name, Class<?> clazz) {
        InputStream is = ServiceProvider.getResourceAsStream(ServiceProvider.getContextClassLoader(), name);
        if (is != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                String serviceName = reader.readLine();
                reader.close();
                if (serviceName != null && !"".equals(serviceName)) {
                    return ServiceProvider.initService(ServiceProvider.getContextClassLoader(), serviceName, clazz);
                }
                LOG.warn("ServiceName is empty!");
                return null;
            }
            catch (Exception e) {
                LOG.warn("Error occurred when looking for resource file " + name, (Throwable)e);
            }
        }
        return null;
    }

    protected static <T> T initService(ClassLoader classLoader, String serviceName, Class<?> clazz) {
        Class<?> serviceClazz;
        block9: {
            serviceClazz = null;
            try {
                if (classLoader == null) break block9;
                try {
                    serviceClazz = classLoader.loadClass(serviceName);
                    if (clazz.isAssignableFrom(serviceClazz)) {
                        LOG.info("Loaded class {} from classloader {}", (Object)serviceClazz.getName(), (Object)ServiceProvider.objectId(classLoader));
                    } else {
                        LOG.error("Class {} loaded from classloader {} does not extend {} as loaded by this classloader.", new Object[]{serviceClazz.getName(), ServiceProvider.objectId(serviceClazz.getClassLoader()), clazz.getName()});
                    }
                    return (T)serviceClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException ex) {
                    if (classLoader == thisClassLoader) {
                        LOG.warn("Unable to locate any class {} via classloader {}", (Object)serviceName, (Object)ServiceProvider.objectId(classLoader));
                        throw ex;
                    }
                }
                catch (NoClassDefFoundError e) {
                    if (classLoader == thisClassLoader) {
                        LOG.warn("Class {} cannot be loaded via classloader {}.it depends on some other class that cannot be found.", serviceClazz, (Object)ServiceProvider.objectId(classLoader));
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Unable to init service.", (Throwable)e);
            }
        }
        return (T)serviceClazz;
    }
}

