/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.failover;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;

public class EscapeBridge {
    protected static final InternalLogger LOG = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long SEND_TIMEOUT = 3000L;
    private static final long DEFAULT_PULL_TIMEOUT_MILLIS = 10000L;
    private final String innerProducerGroupName;
    private final String innerConsumerGroupName;
    private final BrokerController brokerController;
    private ExecutorService defaultAsyncSenderExecutor;

    public EscapeBridge(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.innerProducerGroupName = "InnerProducerGroup_" + brokerController.getBrokerConfig().getBrokerName() + "_" + brokerController.getBrokerConfig().getBrokerId();
        this.innerConsumerGroupName = "InnerConsumerGroup_" + brokerController.getBrokerConfig().getBrokerName() + "_" + brokerController.getBrokerConfig().getBrokerId();
    }

    public void start() throws Exception {
        if (this.brokerController.getBrokerConfig().isEnableSlaveActingMaster() && this.brokerController.getBrokerConfig().isEnableRemoteEscape()) {
            LinkedBlockingQueue<Runnable> asyncSenderThreadPoolQueue = new LinkedBlockingQueue<Runnable>(50000);
            this.defaultAsyncSenderExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60000L, TimeUnit.MILLISECONDS, asyncSenderThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("AsyncEscapeBridgeExecutor_", this.brokerController.getBrokerIdentity()));
            LOG.info("init executor for escaping messages asynchronously success.");
        }
    }

    public void shutdown() {
        if (null != this.defaultAsyncSenderExecutor) {
            this.defaultAsyncSenderExecutor.shutdown();
        }
    }

    public PutMessageResult putMessage(MessageExtBrokerInner messageExt) {
        BrokerController masterBroker = this.brokerController.peekMasterBroker();
        if (masterBroker != null) {
            return masterBroker.getMessageStore().putMessage(messageExt);
        }
        if (this.brokerController.getBrokerConfig().isEnableSlaveActingMaster() && this.brokerController.getBrokerConfig().isEnableRemoteEscape()) {
            try {
                messageExt.setWaitStoreMsgOK(false);
                SendResult sendResult = this.putMessageToRemoteBroker(messageExt);
                return this.transformSendResult2PutResult(sendResult);
            }
            catch (Exception e) {
                LOG.error("sendMessageInFailover to remote failed", (Throwable)e);
                return new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true);
            }
        }
        LOG.warn("Put message failed, enableSlaveActingMaster={}, enableRemoteEscape={}.", (Object)this.brokerController.getBrokerConfig().isEnableSlaveActingMaster(), (Object)this.brokerController.getBrokerConfig().isEnableRemoteEscape());
        return new PutMessageResult(PutMessageStatus.SERVICE_NOT_AVAILABLE, null);
    }

    private SendResult putMessageToRemoteBroker(MessageExtBrokerInner messageExt) {
        TopicPublishInfo topicPublishInfo = this.brokerController.getTopicRouteInfoManager().tryToFindTopicPublishInfo(messageExt.getTopic());
        if (null == topicPublishInfo || !topicPublishInfo.ok()) {
            LOG.warn("putMessageToRemoteBroker: no route info of topic {} when escaping message, msgId={}", (Object)messageExt.getTopic(), (Object)messageExt.getMsgId());
            return null;
        }
        MessageQueue mqSelected = topicPublishInfo.selectOneMessageQueue();
        messageExt.setQueueId(mqSelected.getQueueId());
        String brokerNameToSend = mqSelected.getBrokerName();
        String brokerAddrToSend = this.brokerController.getTopicRouteInfoManager().findBrokerAddressInPublish(brokerNameToSend);
        long beginTimestamp = System.currentTimeMillis();
        try {
            SendResult sendResult = this.brokerController.getBrokerOuterAPI().sendMessageToSpecificBroker(brokerAddrToSend, brokerNameToSend, (MessageExt)messageExt, this.getProducerGroup(messageExt), 3000L);
            if (null != sendResult && SendStatus.SEND_OK.equals((Object)sendResult.getSendStatus())) {
                return sendResult;
            }
            LOG.error("Escaping failed! cost {}ms, Topic: {}, MsgId: {}, Broker: {}", new Object[]{System.currentTimeMillis() - beginTimestamp, messageExt.getTopic(), messageExt.getMsgId(), brokerNameToSend});
        }
        catch (MQBrokerException | RemotingException e) {
            LOG.error(String.format("putMessageToRemoteBroker exception, MsgId: %s, RT: %sms, Broker: %s", messageExt.getMsgId(), System.currentTimeMillis() - beginTimestamp, mqSelected), e);
        }
        catch (InterruptedException e) {
            LOG.error(String.format("putMessageToRemoteBroker interrupted, MsgId: %s, RT: %sms, Broker: %s", messageExt.getMsgId(), System.currentTimeMillis() - beginTimestamp, mqSelected), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public CompletableFuture<PutMessageResult> asyncPutMessage(MessageExtBrokerInner messageExt) {
        BrokerController masterBroker = this.brokerController.peekMasterBroker();
        if (masterBroker != null) {
            return masterBroker.getMessageStore().asyncPutMessage(messageExt);
        }
        if (this.brokerController.getBrokerConfig().isEnableSlaveActingMaster() && this.brokerController.getBrokerConfig().isEnableRemoteEscape()) {
            try {
                messageExt.setWaitStoreMsgOK(false);
                TopicPublishInfo topicPublishInfo = this.brokerController.getTopicRouteInfoManager().tryToFindTopicPublishInfo(messageExt.getTopic());
                String producerGroup = this.getProducerGroup(messageExt);
                MessageQueue mqSelected = topicPublishInfo.selectOneMessageQueue();
                messageExt.setQueueId(mqSelected.getQueueId());
                String brokerNameToSend = mqSelected.getBrokerName();
                String brokerAddrToSend = this.brokerController.getTopicRouteInfoManager().findBrokerAddressInPublish(brokerNameToSend);
                CompletableFuture<SendResult> future = this.brokerController.getBrokerOuterAPI().sendMessageToSpecificBrokerAsync(brokerAddrToSend, brokerNameToSend, (MessageExt)messageExt, producerGroup, 3000L);
                return ((CompletableFuture)((CompletableFuture)future.exceptionally(throwable -> null)).thenApplyAsync(sendResult -> this.transformSendResult2PutResult((SendResult)sendResult), (Executor)this.defaultAsyncSenderExecutor)).exceptionally(throwable -> this.transformSendResult2PutResult(null));
            }
            catch (Exception e) {
                LOG.error("sendMessageInFailover to remote failed", (Throwable)e);
                return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true));
            }
        }
        LOG.warn("Put message failed, enableSlaveActingMaster={}, enableRemoteEscape={}.", (Object)this.brokerController.getBrokerConfig().isEnableSlaveActingMaster(), (Object)this.brokerController.getBrokerConfig().isEnableRemoteEscape());
        return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.SERVICE_NOT_AVAILABLE, null));
    }

    private String getProducerGroup(MessageExtBrokerInner messageExt) {
        if (null == messageExt) {
            return this.innerProducerGroupName;
        }
        String producerGroup = messageExt.getProperty("PGROUP");
        if (StringUtils.isEmpty((CharSequence)producerGroup)) {
            producerGroup = this.innerProducerGroupName;
        }
        return producerGroup;
    }

    public PutMessageResult putMessageToSpecificQueue(MessageExtBrokerInner messageExt) {
        BrokerController masterBroker = this.brokerController.peekMasterBroker();
        if (masterBroker != null) {
            return masterBroker.getMessageStore().putMessage(messageExt);
        }
        if (this.brokerController.getBrokerConfig().isEnableSlaveActingMaster() && this.brokerController.getBrokerConfig().isEnableRemoteEscape()) {
            try {
                messageExt.setWaitStoreMsgOK(false);
                TopicPublishInfo topicPublishInfo = this.brokerController.getTopicRouteInfoManager().tryToFindTopicPublishInfo(messageExt.getTopic());
                List mqs = topicPublishInfo.getMessageQueueList();
                if (null == mqs || mqs.isEmpty()) {
                    return new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true);
                }
                String id = messageExt.getTopic() + messageExt.getStoreHost();
                int index = Math.floorMod(id.hashCode(), mqs.size());
                MessageQueue mq = (MessageQueue)mqs.get(index);
                messageExt.setQueueId(mq.getQueueId());
                String brokerNameToSend = mq.getBrokerName();
                String brokerAddrToSend = this.brokerController.getTopicRouteInfoManager().findBrokerAddressInPublish(brokerNameToSend);
                SendResult sendResult = this.brokerController.getBrokerOuterAPI().sendMessageToSpecificBroker(brokerAddrToSend, brokerNameToSend, (MessageExt)messageExt, this.getProducerGroup(messageExt), 3000L);
                return this.transformSendResult2PutResult(sendResult);
            }
            catch (Exception e) {
                LOG.error("sendMessageInFailover to remote failed", (Throwable)e);
                return new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true);
            }
        }
        LOG.warn("Put message to specific queue failed, enableSlaveActingMaster={}, enableRemoteEscape={}.", (Object)this.brokerController.getBrokerConfig().isEnableSlaveActingMaster(), (Object)this.brokerController.getBrokerConfig().isEnableRemoteEscape());
        return new PutMessageResult(PutMessageStatus.SERVICE_NOT_AVAILABLE, null);
    }

    private PutMessageResult transformSendResult2PutResult(SendResult sendResult) {
        if (sendResult == null) {
            return new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true);
        }
        switch (sendResult.getSendStatus()) {
            case SEND_OK: {
                return new PutMessageResult(PutMessageStatus.PUT_OK, null, true);
            }
            case SLAVE_NOT_AVAILABLE: {
                return new PutMessageResult(PutMessageStatus.SLAVE_NOT_AVAILABLE, null, true);
            }
            case FLUSH_DISK_TIMEOUT: {
                return new PutMessageResult(PutMessageStatus.FLUSH_DISK_TIMEOUT, null, true);
            }
            case FLUSH_SLAVE_TIMEOUT: {
                return new PutMessageResult(PutMessageStatus.FLUSH_SLAVE_TIMEOUT, null, true);
            }
        }
        return new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true);
    }

    public MessageExt getMessage(String topic, long offset, int queueId, String brokerName) {
        MessageStore messageStore = this.brokerController.getMessageStoreByBrokerName(brokerName);
        if (messageStore != null) {
            GetMessageResult getMessageTmpResult = messageStore.getMessage(this.innerConsumerGroupName, topic, queueId, offset, 1, null);
            if (getMessageTmpResult == null) {
                LOG.warn("getMessageResult is null , innerConsumerGroupName {}, topic {}, offset {}, queueId {}", new Object[]{this.innerConsumerGroupName, topic, offset, queueId});
                return null;
            }
            List<MessageExt> list = this.decodeMsgList(getMessageTmpResult);
            if (list == null || list.isEmpty()) {
                LOG.warn("Can not get msg , topic {}, offset {}, queueId {}, result is {}", new Object[]{topic, offset, queueId, getMessageTmpResult});
                return null;
            }
            return list.get(0);
        }
        return this.getMessageFromRemote(topic, offset, queueId, brokerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MessageExt> decodeMsgList(GetMessageResult getMessageResult) {
        ArrayList<MessageExt> foundList = new ArrayList<MessageExt>();
        try {
            List messageBufferList = getMessageResult.getMessageBufferList();
            if (messageBufferList != null) {
                for (int i = 0; i < messageBufferList.size(); ++i) {
                    ByteBuffer bb = (ByteBuffer)messageBufferList.get(i);
                    if (bb == null) {
                        LOG.error("bb is null {}", (Object)getMessageResult);
                        continue;
                    }
                    MessageExt msgExt = MessageDecoder.decode((ByteBuffer)bb);
                    if (msgExt == null) {
                        LOG.error("decode msgExt is null {}", (Object)getMessageResult);
                        continue;
                    }
                    msgExt.setQueueOffset(((Long)getMessageResult.getMessageQueueOffset().get(i)).longValue());
                    foundList.add(msgExt);
                }
            }
        }
        finally {
            getMessageResult.release();
        }
        return foundList;
    }

    protected MessageExt getMessageFromRemote(String topic, long offset, int queueId, String brokerName) {
        try {
            PullResult pullResult;
            String brokerAddr = this.brokerController.getTopicRouteInfoManager().findBrokerAddressInSubscribe(brokerName, 0L, false);
            if (null == brokerAddr) {
                this.brokerController.getTopicRouteInfoManager().updateTopicRouteInfoFromNameServer(topic, true, false);
                brokerAddr = this.brokerController.getTopicRouteInfoManager().findBrokerAddressInSubscribe(brokerName, 0L, false);
                if (null == brokerAddr) {
                    LOG.warn("can't find broker address for topic {}", (Object)topic);
                    return null;
                }
            }
            if ((pullResult = this.brokerController.getBrokerOuterAPI().pullMessageFromSpecificBroker(brokerName, brokerAddr, this.innerConsumerGroupName, topic, queueId, offset, 1, 10000L)).getPullStatus().equals((Object)PullStatus.FOUND)) {
                return (MessageExt)pullResult.getMsgFoundList().get(0);
            }
        }
        catch (Exception e) {
            LOG.error("Get message from remote failed.", (Throwable)e);
        }
        return null;
    }
}

