/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.consumer;

import io.openmessaging.KeyValue;
import io.openmessaging.Message;
import io.openmessaging.consumer.PullConsumer;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.rocketmq.config.ClientConfig;
import io.openmessaging.rocketmq.consumer.LocalMessageCache;
import io.openmessaging.rocketmq.domain.ConsumeRequest;
import io.openmessaging.rocketmq.utils.BeanUtils;
import io.openmessaging.rocketmq.utils.OMSUtil;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.MQPullConsumer;
import org.apache.rocketmq.client.consumer.MQPullConsumerScheduleService;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullTaskCallback;
import org.apache.rocketmq.client.consumer.PullTaskContext;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.log.ClientLogger;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.remoting.protocol.LanguageCode;

public class PullConsumerImpl
implements PullConsumer {
    private final DefaultMQPullConsumer rocketmqPullConsumer;
    private final KeyValue properties;
    private boolean started = false;
    private final MQPullConsumerScheduleService pullConsumerScheduleService;
    private final LocalMessageCache localMessageCache;
    private final ClientConfig clientConfig;
    private static final InternalLogger log = ClientLogger.getLog();

    public PullConsumerImpl(KeyValue properties) {
        this.properties = properties;
        this.clientConfig = (ClientConfig)((Object)BeanUtils.populate(properties, ClientConfig.class));
        String consumerGroup = this.clientConfig.getConsumerId();
        if (null == consumerGroup || consumerGroup.isEmpty()) {
            throw new OMSRuntimeException("-1", "Consumer Group is necessary for RocketMQ, please set it.");
        }
        this.pullConsumerScheduleService = new MQPullConsumerScheduleService(consumerGroup);
        this.rocketmqPullConsumer = this.pullConsumerScheduleService.getDefaultMQPullConsumer();
        if ("true".equalsIgnoreCase(System.getenv("OMS_RMQ_DIRECT_NAME_SRV"))) {
            String accessPoints = this.clientConfig.getAccessPoints();
            if (accessPoints == null || accessPoints.isEmpty()) {
                throw new OMSRuntimeException("-1", "OMS AccessPoints is null or empty.");
            }
            this.rocketmqPullConsumer.setNamesrvAddr(accessPoints.replace(',', ';'));
        }
        this.rocketmqPullConsumer.setConsumerGroup(consumerGroup);
        int maxReDeliveryTimes = this.clientConfig.getRmqMaxRedeliveryTimes();
        this.rocketmqPullConsumer.setMaxReconsumeTimes(maxReDeliveryTimes);
        String consumerId = OMSUtil.buildInstanceName();
        this.rocketmqPullConsumer.setInstanceName(consumerId);
        properties.put("CONSUMER_ID", consumerId);
        this.rocketmqPullConsumer.setLanguage(LanguageCode.OMS);
        this.localMessageCache = new LocalMessageCache(this.rocketmqPullConsumer, this.clientConfig);
    }

    public KeyValue attributes() {
        return this.properties;
    }

    public PullConsumer attachQueue(String queueName) {
        this.registerPullTaskCallback(queueName);
        return this;
    }

    public PullConsumer attachQueue(String queueName, KeyValue attributes) {
        this.registerPullTaskCallback(queueName);
        return this;
    }

    public PullConsumer detachQueue(String queueName) {
        this.rocketmqPullConsumer.getRegisterTopics().remove(queueName);
        return this;
    }

    public Message receive() {
        MessageExt rmqMsg = this.localMessageCache.poll();
        return rmqMsg == null ? null : OMSUtil.msgConvert(rmqMsg);
    }

    public Message receive(KeyValue properties) {
        MessageExt rmqMsg = this.localMessageCache.poll(properties);
        return rmqMsg == null ? null : OMSUtil.msgConvert(rmqMsg);
    }

    public void ack(String messageId) {
        this.localMessageCache.ack(messageId);
    }

    public void ack(String messageId, KeyValue properties) {
        this.localMessageCache.ack(messageId);
    }

    public synchronized void startup() {
        if (!this.started) {
            try {
                this.pullConsumerScheduleService.start();
                this.localMessageCache.startup();
            }
            catch (MQClientException e) {
                throw new OMSRuntimeException("-1", (Throwable)e);
            }
        }
        this.started = true;
    }

    private void registerPullTaskCallback(String targetQueueName) {
        this.pullConsumerScheduleService.registerPullTaskCallback(targetQueueName, new PullTaskCallback(){

            public void doPullTask(MessageQueue mq, PullTaskContext context) {
                MQPullConsumer consumer = context.getPullConsumer();
                try {
                    long offset = PullConsumerImpl.this.localMessageCache.nextPullOffset(mq);
                    PullResult pullResult = consumer.pull(mq, "*", offset, PullConsumerImpl.this.localMessageCache.nextPullBatchNums());
                    ProcessQueue pq = (ProcessQueue)PullConsumerImpl.this.rocketmqPullConsumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getProcessQueueTable().get(mq);
                    switch (pullResult.getPullStatus()) {
                        case FOUND: {
                            if (pq == null) break;
                            pq.putMessage(pullResult.getMsgFoundList());
                            for (MessageExt messageExt : pullResult.getMsgFoundList()) {
                                PullConsumerImpl.this.localMessageCache.submitConsumeRequest(new ConsumeRequest(messageExt, mq, pq));
                            }
                            break;
                        }
                    }
                    PullConsumerImpl.this.localMessageCache.updatePullOffset(mq, pullResult.getNextBeginOffset());
                }
                catch (Exception e) {
                    log.error("An error occurred in pull message process.", (Throwable)e);
                }
            }
        });
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.localMessageCache.shutdown();
            this.pullConsumerScheduleService.shutdown();
            this.rocketmqPullConsumer.shutdown();
        }
        this.started = false;
    }
}

