/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.ConcurrentQueue;
import com.conversantmedia.util.concurrent.Condition;
import com.conversantmedia.util.concurrent.ContendedAtomicLong;
import com.conversantmedia.util.concurrent.ContendedLong;
import java.util.concurrent.atomic.AtomicLong;

public class MultithreadConcurrentQueue<E>
implements ConcurrentQueue<E> {
    protected final int size;
    protected final long mask;
    protected final AtomicLong tail = new ContendedAtomicLong(0L);
    protected final ContendedLong tailCache = new ContendedLong(0L);
    protected final AtomicLong tailCursor = new ContendedAtomicLong(0L);
    protected final E[] buffer;
    protected final AtomicLong head = new ContendedAtomicLong(0L);
    protected final ContendedLong headCache = new ContendedLong(0L);
    protected final AtomicLong headCursor = new ContendedAtomicLong(0L);

    public MultithreadConcurrentQueue(int capacity) {
        int c;
        for (c = 1; c < capacity; c <<= 1) {
        }
        this.size = c;
        this.mask = (long)this.size - 1L;
        this.buffer = new Object[this.size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        int spin = 0;
        while (true) {
            long tailSeq;
            long queueStart;
            if (this.headCache.value > (queueStart = (tailSeq = this.tail.get()) - (long)this.size) || (this.headCache.value = this.head.get()) > queueStart) {
                long tailNext = tailSeq + 1L;
                if (this.tailCursor.compareAndSet(tailSeq, tailNext)) {
                    try {
                        int tailSlot = (int)(tailSeq & this.mask);
                        this.buffer[tailSlot] = e;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.tail.set(tailNext);
                    }
                }
            } else {
                return false;
            }
            spin = Condition.progressiveYield(spin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        int spin = 0;
        while (true) {
            long head;
            if (this.tailCache.value > (head = this.head.get()) || (this.tailCache.value = this.tail.get()) > head) {
                long headNext = head + 1L;
                if (this.headCursor.compareAndSet(head, headNext)) {
                    try {
                        int pollSlot = (int)(head & this.mask);
                        E pollObj = this.buffer[pollSlot];
                        this.buffer[pollSlot] = null;
                        E e = pollObj;
                        return e;
                    }
                    finally {
                        this.head.set(headNext);
                    }
                }
            } else {
                return null;
            }
            spin = Condition.progressiveYield(spin);
        }
    }

    @Override
    public final E peek() {
        return this.buffer[(int)(this.head.get() & this.mask)];
    }

    @Override
    public int remove(E[] e) {
        int maxElements = e.length;
        int spin = 0;
        while (true) {
            long pollPos = this.head.get();
            int nToRead = Math.min((int)(this.tail.get() - pollPos), maxElements);
            if (nToRead > 0) {
                for (int i = 0; i < nToRead; ++i) {
                    int pollSlot = (int)(pollPos + (long)i & this.mask);
                    e[i] = this.buffer[pollSlot];
                }
                if (this.headCursor.compareAndSet(pollPos, pollPos + (long)nToRead)) {
                    this.head.set(pollPos + (long)nToRead);
                    return nToRead;
                }
            } else {
                return 0;
            }
            spin = Condition.progressiveYield(spin);
        }
    }

    @Override
    public final int size() {
        return (int)Math.max(this.tail.get() - this.head.get(), 0L);
    }

    @Override
    public int capacity() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.tail.get() == this.head.get();
    }

    @Override
    public void clear() {
        int spin = 0;
        while (true) {
            long head;
            if (this.headCursor.compareAndSet(head = this.head.get(), head + 1L)) {
                while (true) {
                    long tail;
                    if (this.tailCursor.compareAndSet(tail = this.tail.get(), tail + 1L)) {
                        for (int i = 0; i < this.buffer.length; ++i) {
                            this.buffer[i] = null;
                        }
                        this.head.set(tail + 1L);
                        this.tail.set(tail + 1L);
                        this.headCursor.set(tail + 1L);
                        return;
                    }
                    spin = Condition.progressiveYield(spin);
                }
            }
            spin = Condition.progressiveYield(spin);
        }
    }

    @Override
    public final boolean contains(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            int slot = (int)(this.head.get() + (long)i & this.mask);
            if (this.buffer[slot] == null || !this.buffer[slot].equals(o)) continue;
            return true;
        }
        return false;
    }
}

