/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.heartbeat;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import io.netty.channel.Channel;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.controller.BrokerHeartbeatManager;
import org.apache.rocketmq.controller.helper.BrokerLifecycleListener;
import org.apache.rocketmq.controller.impl.JRaftController;
import org.apache.rocketmq.controller.impl.heartbeat.BrokerIdentityInfo;
import org.apache.rocketmq.controller.impl.heartbeat.BrokerLiveInfo;
import org.apache.rocketmq.controller.impl.task.BrokerCloseChannelRequest;
import org.apache.rocketmq.controller.impl.task.CheckNotActiveBrokerRequest;
import org.apache.rocketmq.controller.impl.task.GetBrokerLiveInfoRequest;
import org.apache.rocketmq.controller.impl.task.GetBrokerLiveInfoResponse;
import org.apache.rocketmq.controller.impl.task.RaftBrokerHeartBeatEventRequest;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class RaftBrokerHeartBeatManager
implements BrokerHeartbeatManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private JRaftController controller;
    private final List<BrokerLifecycleListener> brokerLifecycleListeners = new ArrayList<BrokerLifecycleListener>();
    private final ScheduledExecutorService scheduledService;
    private final ExecutorService executor;
    private final ControllerConfig controllerConfig;
    private final Map<Channel, BrokerIdentityInfo> brokerChannelIdentityInfoMap = new HashMap<Channel, BrokerIdentityInfo>();
    private long firstReceivedHeartbeatTime = -1L;

    public RaftBrokerHeartBeatManager(ControllerConfig controllerConfig) {
        this.scheduledService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("RaftBrokerHeartbeatManager_scheduledService_"));
        this.executor = Executors.newFixedThreadPool(2, (ThreadFactory)new ThreadFactoryImpl("RaftBrokerHeartbeatManager_executorService_"));
        this.controllerConfig = controllerConfig;
    }

    public void setController(JRaftController controller) {
        this.controller = controller;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        this.scheduledService.scheduleAtFixedRate(this::scanNotActiveBroker, 2000L, this.controllerConfig.getScanNotActiveBrokerInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.scheduledService.shutdown();
        this.executor.shutdown();
    }

    @Override
    public void registerBrokerLifecycleListener(BrokerLifecycleListener listener) {
        this.brokerLifecycleListeners.add(listener);
    }

    @Override
    public void onBrokerHeartbeat(String clusterName, String brokerName, String brokerAddr, Long brokerId, Long timeoutMillis, Channel channel, Integer epoch, Long maxOffset, Long confirmOffset, Integer electionPriority) {
        if (this.firstReceivedHeartbeatTime == -1L) {
            this.firstReceivedHeartbeatTime = System.currentTimeMillis();
        }
        BrokerIdentityInfo brokerIdentityInfo = new BrokerIdentityInfo(clusterName, brokerName, brokerId);
        int realEpoch = Optional.ofNullable(epoch).orElse(-1);
        long realBrokerId = Optional.ofNullable(brokerId).orElse(-1L);
        long realMaxOffset = Optional.ofNullable(maxOffset).orElse(-1L);
        long realConfirmOffset = Optional.ofNullable(confirmOffset).orElse(-1L);
        long realTimeoutMillis = Optional.ofNullable(timeoutMillis).orElse(10000L);
        int realElectionPriority = Optional.ofNullable(electionPriority).orElse(Integer.MAX_VALUE);
        BrokerLiveInfo liveInfo = new BrokerLiveInfo(brokerName, brokerAddr, realBrokerId, System.currentTimeMillis(), realTimeoutMillis, null, realEpoch, realMaxOffset, realElectionPriority, realConfirmOffset);
        log.info("broker {} heart beat", (Object)brokerIdentityInfo);
        RaftBrokerHeartBeatEventRequest requestHeader = new RaftBrokerHeartBeatEventRequest(brokerIdentityInfo, liveInfo);
        CompletableFuture<RemotingCommand> future = this.controller.onBrokerHeartBeat(requestHeader);
        try {
            RemotingCommand remotingCommand = future.get(5L, TimeUnit.SECONDS);
            if (remotingCommand.getCode() != 0 && remotingCommand.getCode() != 2007) {
                throw new RuntimeException("on broker heartbeat return invalid code, code: " + remotingCommand.getCode());
            }
        }
        catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException e) {
            log.error("on broker heartbeat through raft failed", (Throwable)e);
        }
        this.brokerChannelIdentityInfoMap.put(channel, brokerIdentityInfo);
    }

    @Override
    public void onBrokerChannelClose(Channel channel) {
        BrokerIdentityInfo brokerIdentityInfo = this.brokerChannelIdentityInfoMap.get(channel);
        log.info("Channel {} inactive, broker identity info: {}", (Object)channel, (Object)brokerIdentityInfo);
        if (brokerIdentityInfo != null) {
            BrokerCloseChannelRequest requestHeader = new BrokerCloseChannelRequest(brokerIdentityInfo);
            CompletableFuture<RemotingCommand> future = this.controller.onBrokerCloseChannel(requestHeader);
            try {
                RemotingCommand remotingCommand = future.get(5L, TimeUnit.SECONDS);
                if (remotingCommand.getCode() != 0) {
                    throw new RuntimeException("on broker close channel return invalid code, code: " + remotingCommand.getCode());
                }
                this.executor.submit(() -> this.notifyBrokerInActive(brokerIdentityInfo.getClusterName(), brokerIdentityInfo.getBrokerName(), brokerIdentityInfo.getBrokerId()));
                this.brokerChannelIdentityInfoMap.remove(channel);
            }
            catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException e) {
                log.error("on broker close channel through raft failed", (Throwable)e);
            }
        }
    }

    private Map<BrokerIdentityInfo, BrokerLiveInfo> getBrokerLiveInfo(BrokerIdentityInfo brokerIdentityInfo) {
        GetBrokerLiveInfoRequest requestHeader = brokerIdentityInfo == null ? new GetBrokerLiveInfoRequest() : new GetBrokerLiveInfoRequest(brokerIdentityInfo);
        CompletableFuture<RemotingCommand> future = this.controller.getBrokerLiveInfo(requestHeader);
        try {
            RemotingCommand remotingCommand = future.get(5L, TimeUnit.SECONDS);
            if (remotingCommand.getCode() != 0) {
                throw new RuntimeException("get broker live info return invalid code, code: " + remotingCommand.getCode());
            }
            GetBrokerLiveInfoResponse getBrokerLiveInfoResponse = (GetBrokerLiveInfoResponse)remotingCommand.decodeCommandCustomHeader(GetBrokerLiveInfoResponse.class);
            return (Map)JSON.parseObject((byte[])remotingCommand.getBody(), (Type)new TypeReference<Map<BrokerIdentityInfo, BrokerLiveInfo>>(){}.getType(), (Feature[])new Feature[0]);
        }
        catch (Throwable e) {
            log.error("get broker live info through raft failed", e);
            return new HashMap<BrokerIdentityInfo, BrokerLiveInfo>();
        }
    }

    private void scanNotActiveBroker() {
        if (!this.controller.isLeaderState()) {
            log.info("current node is not leader, skip scan not active broker");
            return;
        }
        if (this.firstReceivedHeartbeatTime + (long)this.controllerConfig.getJraftConfig().getjRaftScanWaitTimeoutMs() < System.currentTimeMillis()) {
            log.info("has not received any heartbeat from broker, skip scan not active broker");
            return;
        }
        log.info("start scan not active broker");
        CheckNotActiveBrokerRequest requestHeader = new CheckNotActiveBrokerRequest();
        CompletableFuture<RemotingCommand> future = this.controller.checkNotActiveBroker(requestHeader);
        try {
            RemotingCommand remotingCommand = future.get(5L, TimeUnit.SECONDS);
            if (remotingCommand.getCode() != 0) {
                throw new RuntimeException("check not active broker return invalid code, code: " + remotingCommand.getCode());
            }
            List notActiveAndNeedReElectBrokerIdentityInfoList = (List)JSON.parseObject((byte[])remotingCommand.getBody(), (Type)new TypeReference<List<BrokerIdentityInfo>>(){}.getType(), (Feature[])new Feature[0]);
            if (notActiveAndNeedReElectBrokerIdentityInfoList != null && !notActiveAndNeedReElectBrokerIdentityInfoList.isEmpty()) {
                notActiveAndNeedReElectBrokerIdentityInfoList.forEach(brokerIdentityInfo -> {
                    Iterator<Map.Entry<Channel, BrokerIdentityInfo>> iterator = this.brokerChannelIdentityInfoMap.entrySet().iterator();
                    Channel channel = null;
                    while (iterator.hasNext()) {
                        Map.Entry<Channel, BrokerIdentityInfo> entry = iterator.next();
                        if (entry.getValue().getBrokerId() == null || !entry.getValue().equals(brokerIdentityInfo)) continue;
                        channel = entry.getKey();
                        RemotingHelper.closeChannel((Channel)entry.getKey());
                        iterator.remove();
                        break;
                    }
                    this.executor.submit(() -> this.notifyBrokerInActive(brokerIdentityInfo.getClusterName(), brokerIdentityInfo.getBrokerName(), brokerIdentityInfo.getBrokerId()));
                    log.warn("The broker channel {} expired, brokerInfo {}", channel, brokerIdentityInfo);
                });
            }
        }
        catch (Throwable e) {
            log.error("check not active broker through raft failed", e);
        }
    }

    @Override
    public BrokerLiveInfo getBrokerLiveInfo(String clusterName, String brokerName, Long brokerId) {
        log.info("get broker live info, clusterName: {}, brokerName: {}, brokerId: {}", new Object[]{clusterName, brokerName, brokerId});
        BrokerIdentityInfo brokerIdentityInfo = new BrokerIdentityInfo(clusterName, brokerName, brokerId);
        Map<BrokerIdentityInfo, BrokerLiveInfo> brokerLiveInfoMap = this.getBrokerLiveInfo(brokerIdentityInfo);
        return brokerLiveInfoMap.get(brokerIdentityInfo);
    }

    @Override
    public boolean isBrokerActive(String clusterName, String brokerName, Long brokerId) {
        BrokerLiveInfo info = null;
        try {
            info = this.getBrokerLiveInfo(clusterName, brokerName, brokerId);
        }
        catch (RuntimeException e) {
            log.error("get broker live info failed", (Throwable)e);
            return false;
        }
        if (info != null) {
            long timeoutMillis;
            long last = info.getLastUpdateTimestamp();
            return last + (timeoutMillis = info.getHeartbeatTimeoutMillis()) >= System.currentTimeMillis();
        }
        return false;
    }

    @Override
    public Map<String, Map<String, Integer>> getActiveBrokersNum() {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        Map<BrokerIdentityInfo, BrokerLiveInfo> brokerLiveInfoMap = this.getBrokerLiveInfo(null);
        brokerLiveInfoMap.keySet().stream().filter(brokerIdentity -> this.isBrokerActive(brokerIdentity.getClusterName(), brokerIdentity.getBrokerName(), brokerIdentity.getBrokerId())).forEach(id -> {
            map.computeIfAbsent(id.getClusterName(), k -> new HashMap());
            ((Map)map.get(id.getClusterName())).compute(id.getBrokerName(), (broker, num) -> num == null ? 0 : num + 1);
        });
        return map;
    }

    private void notifyBrokerInActive(String clusterName, String brokerName, Long brokerId) {
        log.info("Broker {}-{}-{} inactive", new Object[]{clusterName, brokerName, brokerId});
        for (BrokerLifecycleListener listener : this.brokerLifecycleListeners) {
            listener.onBrokerInactive(clusterName, brokerName, brokerId);
        }
    }
}

