/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import java.nio.charset.Charset;
import org.apache.commons.lang3.SerializationException;
import org.apache.rocketmq.common.utils.Serializer;

public class FastJsonSerializer
implements Serializer {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    @Override
    public <T> byte[] serialize(T t) throws SerializationException {
        if (t == null) {
            return new byte[0];
        }
        try {
            return JSON.toJSONBytes((Charset)this.fastJsonConfig.getCharset(), t, (SerializeConfig)this.fastJsonConfig.getSerializeConfig(), (SerializeFilter[])this.fastJsonConfig.getSerializeFilters(), (String)this.fastJsonConfig.getDateFormat(), (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])this.fastJsonConfig.getSerializerFeatures());
        }
        catch (Exception var3) {
            throw new SerializationException("Could not serialize: " + var3.getMessage(), (Throwable)var3);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> type) throws SerializationException {
        if (bytes != null && bytes.length != 0) {
            try {
                return (T)JSON.parseObject((byte[])bytes, (Charset)this.fastJsonConfig.getCharset(), type, (ParserConfig)this.fastJsonConfig.getParserConfig(), (ParseProcess)this.fastJsonConfig.getParseProcess(), (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])this.fastJsonConfig.getFeatures());
            }
            catch (Exception var3) {
                throw new SerializationException("Could not deserialize: " + var3.getMessage(), (Throwable)var3);
            }
        }
        return null;
    }
}

