/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.benchmark;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.rocketmq.example.benchmark.Snapshot;

class StatsBenchmarkTProducer {
    private final LongAdder sendRequestSuccessCount = new LongAdder();
    private final LongAdder sendRequestFailedCount = new LongAdder();
    private final LongAdder sendMessageTimeTotal = new LongAdder();
    private final AtomicLong sendMessageMaxRT = new AtomicLong(0L);
    private final LongAdder checkCount = new LongAdder();
    private final LongAdder unexpectedCheckCount = new LongAdder();
    private final LongAdder duplicatedCheckCount = new LongAdder();

    StatsBenchmarkTProducer() {
    }

    public Snapshot createSnapshot() {
        Snapshot s = new Snapshot();
        s.endTime = System.currentTimeMillis();
        s.sendRequestSuccessCount = this.sendRequestSuccessCount.longValue();
        s.sendRequestFailedCount = this.sendRequestFailedCount.longValue();
        s.sendMessageTimeTotal = this.sendMessageTimeTotal.longValue();
        s.sendMessageMaxRT = this.sendMessageMaxRT.get();
        s.checkCount = this.checkCount.longValue();
        s.unexpectedCheckCount = this.unexpectedCheckCount.longValue();
        s.duplicatedCheck = this.duplicatedCheckCount.longValue();
        return s;
    }

    public LongAdder getSendRequestSuccessCount() {
        return this.sendRequestSuccessCount;
    }

    public LongAdder getSendRequestFailedCount() {
        return this.sendRequestFailedCount;
    }

    public LongAdder getSendMessageTimeTotal() {
        return this.sendMessageTimeTotal;
    }

    public AtomicLong getSendMessageMaxRT() {
        return this.sendMessageMaxRT;
    }

    public LongAdder getCheckCount() {
        return this.checkCount;
    }

    public LongAdder getUnexpectedCheckCount() {
        return this.unexpectedCheckCount;
    }

    public LongAdder getDuplicatedCheckCount() {
        return this.duplicatedCheckCount;
    }
}

