/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.config;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.apache.rocketmq.common.config.ConfigHelper;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;

public class ConfigRocksDBStorage
extends AbstractRocksDBStorage {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final ConcurrentMap<String, ConfigRocksDBStorage> STORE_MAP = new ConcurrentHashMap<String, ConfigRocksDBStorage>();
    private final ConcurrentHashMap<String, ColumnFamilyHandle> columnFamilyNameHandleMap;
    private ColumnFamilyOptions columnFamilyOptions;

    private ConfigRocksDBStorage(String dbPath, boolean readOnly, CompressionType compressionType) {
        super(dbPath);
        this.readOnly = readOnly;
        if (compressionType != null) {
            this.compressionType = compressionType;
        }
        this.columnFamilyNameHandleMap = new ConcurrentHashMap();
    }

    public ConfigRocksDBStorage(String dbPath, boolean readOnly) {
        this(dbPath, readOnly, null);
    }

    @Override
    protected void initOptions() {
        this.options = ConfigHelper.createConfigDBOptions();
        this.columnFamilyOptions = ConfigHelper.createConfigColumnFamilyOptions();
        this.cfOptions.add(this.columnFamilyOptions);
        super.initOptions();
    }

    @Override
    protected boolean postLoad() {
        try {
            UtilAll.ensureDirOK(this.dbPath);
            this.initOptions();
            ArrayList<byte[]> columnFamilyNames = new ArrayList<byte[]>(RocksDB.listColumnFamilies((Options)new Options(this.options, this.columnFamilyOptions), (String)this.dbPath));
            this.addIfNotExists(columnFamilyNames, RocksDB.DEFAULT_COLUMN_FAMILY);
            ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
            for (byte[] columnFamilyName : columnFamilyNames) {
                cfDescriptors.add(new ColumnFamilyDescriptor(columnFamilyName, this.columnFamilyOptions));
            }
            this.open(cfDescriptors);
            for (int i = 0; i < columnFamilyNames.size(); ++i) {
                this.columnFamilyNameHandleMap.put(new String((byte[])columnFamilyNames.get(i), CHARSET), (ColumnFamilyHandle)this.cfHandles.get(i));
            }
            this.defaultCFHandle = this.columnFamilyNameHandleMap.get(new String(RocksDB.DEFAULT_COLUMN_FAMILY, CHARSET));
        }
        catch (Exception e) {
            AbstractRocksDBStorage.LOGGER.error("postLoad Failed. {}", (Object)this.dbPath, (Object)e);
            return false;
        }
        return true;
    }

    @Override
    protected void preShutdown() {
        for (ColumnFamilyHandle columnFamilyHandle : this.columnFamilyNameHandleMap.values()) {
            if (!columnFamilyHandle.isOwningHandle()) continue;
            columnFamilyHandle.close();
        }
    }

    public void writeBatchPutOperation(String cf, WriteBatch writeBatch, byte[] key, byte[] value) throws RocksDBException {
        writeBatch.put(this.getOrCreateColumnFamily(cf), key, value);
    }

    public void batchPut(WriteBatch batch) throws RocksDBException {
        this.batchPut(this.writeOptions, batch);
    }

    public void batchPutWithWal(WriteBatch batch) throws RocksDBException {
        this.batchPut(this.ableWalWriteOptions, batch);
    }

    public void put(String cf, byte[] keyBytes, int keyLen, byte[] valueBytes) throws Exception {
        this.put(this.getOrCreateColumnFamily(cf), this.ableWalWriteOptions, keyBytes, keyLen, valueBytes, valueBytes.length);
    }

    public void put(String cf, ByteBuffer keyBB, ByteBuffer valueBB) throws Exception {
        this.put(this.getOrCreateColumnFamily(cf), this.ableWalWriteOptions, keyBB, valueBB);
    }

    public byte[] get(String cf, byte[] keyBytes) throws Exception {
        ColumnFamilyHandle columnFamilyHandle = this.columnFamilyNameHandleMap.get(cf);
        if (columnFamilyHandle == null) {
            return null;
        }
        return this.get(columnFamilyHandle, this.totalOrderReadOptions, keyBytes);
    }

    public void delete(String cf, byte[] keyBytes) throws Exception {
        ColumnFamilyHandle columnFamilyHandle = this.columnFamilyNameHandleMap.get(cf);
        if (columnFamilyHandle == null) {
            return;
        }
        this.delete(columnFamilyHandle, this.ableWalWriteOptions, keyBytes);
    }

    public void iterate(String cf, BiConsumer<byte[], byte[]> biConsumer) throws RocksDBException {
        if (!this.hold()) {
            LOGGER.warn("RocksDBKvStore[path={}] has been shut down", (Object)this.dbPath);
            return;
        }
        ColumnFamilyHandle columnFamilyHandle = this.columnFamilyNameHandleMap.get(cf);
        if (columnFamilyHandle == null) {
            return;
        }
        try (RocksIterator iterator = this.db.newIterator(columnFamilyHandle);){
            iterator.seekToFirst();
            while (iterator.isValid()) {
                biConsumer.accept(iterator.key(), iterator.value());
                iterator.next();
            }
            iterator.status();
        }
    }

    public RocksIterator iterator() {
        return this.db.newIterator(this.defaultCFHandle, this.totalOrderReadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnFamilyHandle getOrCreateColumnFamily(String cf) throws RocksDBException {
        if (!this.columnFamilyNameHandleMap.containsKey(cf)) {
            if (this.readOnly) {
                String errInfo = String.format("RocksDBKvStore[path=%s] is open as read-only", this.dbPath);
                LOGGER.warn(errInfo);
                throw new RocksDBException(errInfo);
            }
            ConfigRocksDBStorage configRocksDBStorage = this;
            synchronized (configRocksDBStorage) {
                if (!this.columnFamilyNameHandleMap.containsKey(cf)) {
                    ColumnFamilyDescriptor columnFamilyDescriptor = new ColumnFamilyDescriptor(cf.getBytes(CHARSET), this.columnFamilyOptions);
                    ColumnFamilyHandle columnFamilyHandle = this.db.createColumnFamily(columnFamilyDescriptor);
                    this.columnFamilyNameHandleMap.putIfAbsent(cf, columnFamilyHandle);
                    this.cfHandles.add(columnFamilyHandle);
                }
            }
        }
        return this.columnFamilyNameHandleMap.get(cf);
    }

    public void addIfNotExists(List<byte[]> columnFamilyNames, byte[] byteArray) {
        if (columnFamilyNames.stream().noneMatch(array -> Arrays.equals(array, byteArray))) {
            columnFamilyNames.add(byteArray);
        }
    }

    public static ConfigRocksDBStorage getStore(String path, boolean readOnly, CompressionType compressionType) {
        return ConcurrentHashMapUtils.computeIfAbsent(STORE_MAP, path, k -> new ConfigRocksDBStorage(path, readOnly, compressionType));
    }

    public static ConfigRocksDBStorage getStore(String path, boolean readOnly) {
        return ConfigRocksDBStorage.getStore(path, readOnly, null);
    }

    public static void shutdown(String path) {
        ConfigRocksDBStorage kvStore = (ConfigRocksDBStorage)STORE_MAP.remove(path);
        if (kvStore != null) {
            kvStore.shutdown();
        }
    }

    public static void destroy(String path) {
        ConfigRocksDBStorage kvStore = (ConfigRocksDBStorage)STORE_MAP.remove(path);
        if (kvStore != null) {
            kvStore.shutdown();
            kvStore.destroy();
        }
    }
}

