/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.misc;

import apache.rocketmq.v2.ReceiveMessageRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class Utilities {
    public static final int MASTER_BROKER_ID = 0;
    public static final Locale LOCALE = new Locale("zh", "CN");
    private static final String OS_NAME = "os.name";
    private static final String OS_VERSION = "os.version";
    private static final Random RANDOM = new SecureRandom();
    private static final int PROCESS_ID_NOT_SET = -2;
    private static final int PROCESS_ID_NOT_FOUND = -1;
    private static int processId = -2;
    private static final String HOST_NAME_NOT_FOUND = "HOST_NAME_NOT_FOUND";
    private static final ThreadLocal<String> PROTOCOL_VERSION_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<String> HOST_NAME_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<byte[]> MAC_ADDRESS_THREAD_LOCAL = new ThreadLocal();
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Utilities() {
    }

    public static byte[] macAddress() {
        byte[] macAddress = MAC_ADDRESS_THREAD_LOCAL.get();
        if (null != macAddress) {
            return (byte[])macAddress.clone();
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] mac = networkInterface.getHardwareAddress();
                if (null == mac) continue;
                macAddress = mac;
                MAC_ADDRESS_THREAD_LOCAL.set(macAddress);
                return (byte[])macAddress.clone();
            }
        }
        catch (Throwable networkInterfaces) {
            // empty catch block
        }
        byte[] randomBytes = new byte[6];
        RANDOM.nextBytes(randomBytes);
        macAddress = randomBytes;
        MAC_ADDRESS_THREAD_LOCAL.set(macAddress);
        return (byte[])macAddress.clone();
    }

    public static String getProtocolVersion() {
        String protocolVersion = PROTOCOL_VERSION_THREAD_LOCAL.get();
        if (null != protocolVersion) {
            return protocolVersion;
        }
        protocolVersion = ReceiveMessageRequest.class.getName().split("\\.")[2];
        PROTOCOL_VERSION_THREAD_LOCAL.set(protocolVersion);
        return protocolVersion;
    }

    public static int processId() {
        if (processId != -2) {
            return processId;
        }
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        try {
            processId = Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (Throwable ignore) {
            processId = -1;
        }
        return processId;
    }

    public static String hostName() {
        String hostName = HOST_NAME_THREAD_LOCAL.get();
        if (null != hostName) {
            return hostName;
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            HOST_NAME_THREAD_LOCAL.set(hostName);
            return hostName;
        }
        catch (Throwable ignore) {
            hostName = HOST_NAME_NOT_FOUND;
            HOST_NAME_THREAD_LOCAL.set(hostName);
            return hostName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressBytesGzip(byte[] src, int level) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        Deflater defeater = new Deflater(level);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, defeater);
        try {
            deflaterOutputStream.write(src);
            deflaterOutputStream.finish();
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            defeater.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] uncompressBytesGzip(byte[] src) throws IOException {
        byte[] uncompressData = new byte[src.length];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(src);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        try {
            int length;
            while ((length = inflaterInputStream.read(uncompressData, 0, uncompressData.length)) > 0) {
                byteArrayOutputStream.write(uncompressData, 0, length);
            }
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                inflaterInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String encodeHexString(ByteBuffer byteBuffer, boolean toLowerCase) {
        return new String(Utilities.encodeHex(byteBuffer, toLowerCase));
    }

    public static char[] encodeHex(ByteBuffer byteBuffer, boolean toLowerCase) {
        return Utilities.encodeHex(byteBuffer, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return new String(Utilities.encodeHex(data, toLowerCase));
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Utilities.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(ByteBuffer data, char[] toDigits) {
        return Utilities.encodeHex(data.array(), toDigits);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String crc32CheckSum(byte[] array) {
        CRC32 crc32 = new CRC32();
        crc32.update(array, 0, array.length);
        return Long.toHexString(crc32.getValue()).toUpperCase(LOCALE);
    }

    public static String md5CheckSum(byte[] array) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(array);
        return Utilities.encodeHexString(digest.digest(), false);
    }

    public static String sha1CheckSum(byte[] array) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.update(array);
        return Utilities.encodeHexString(digest.digest(), false);
    }

    public static String stackTrace() {
        return Utilities.stackTrace(Thread.getAllStackTraces());
    }

    public static String stackTrace(Map<Thread, StackTraceElement[]> map) {
        StringBuilder result = new StringBuilder();
        try {
            for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                StackTraceElement[] elements = entry.getValue();
                Thread thread = entry.getKey();
                if (elements == null || elements.length <= 0) continue;
                String threadName = entry.getKey().getName();
                result.append(String.format("%-40sTID: %d STATE: %s%n", new Object[]{threadName, thread.getId(), thread.getState()}));
                for (StackTraceElement el : elements) {
                    result.append(String.format("%-40s%s%n", threadName, el.toString()));
                }
                result.append("\n");
            }
        }
        catch (Throwable e) {
            result.append(e);
        }
        return result.toString();
    }

    public static String getOsDescription() {
        String osName = Utilities.getOsName();
        if (null == osName) {
            return "";
        }
        String version = Utilities.getOsVersion();
        return null != version ? osName + " " + version : osName;
    }

    public static String getOsName() {
        try {
            return System.getProperty(OS_NAME);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getOsVersion() {
        try {
            return System.getProperty(OS_VERSION);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

