/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Predicate;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.ViewBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.view.StringPredicates;

public final class SdkMeterProviderUtil {
    private SdkMeterProviderUtil() {
    }

    public static void setExemplarFilter(SdkMeterProviderBuilder sdkMeterProviderBuilder, ExemplarFilter exemplarFilter) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("setExemplarFilter", ExemplarFilter.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, exemplarFilter);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setExemplarFilter on SdkMeterProviderBuilder", e);
        }
    }

    public static void setMinimumCollectionInterval(SdkMeterProviderBuilder sdkMeterProviderBuilder, Duration duration) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("setMinimumCollectionInterval", Duration.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, duration);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setMinimumCollectionInterval on SdkMeterProviderBuilder", e);
        }
    }

    public static void appendFilteredBaggageAttributes(ViewBuilder viewBuilder, Predicate<String> keyFilter) {
        SdkMeterProviderUtil.addAttributesProcessor(viewBuilder, AttributesProcessor.appendBaggageByKeyName(keyFilter));
    }

    public static void appendAllBaggageAttributes(ViewBuilder viewBuilder) {
        SdkMeterProviderUtil.appendFilteredBaggageAttributes(viewBuilder, StringPredicates.ALL);
    }

    private static void addAttributesProcessor(ViewBuilder viewBuilder, AttributesProcessor attributesProcessor) {
        try {
            Method method = ViewBuilder.class.getDeclaredMethod("addAttributesProcessor", AttributesProcessor.class);
            method.setAccessible(true);
            method.invoke((Object)viewBuilder, attributesProcessor);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error adding AttributesProcessor to ViewBuilder", e);
        }
    }
}

