/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.task;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.adapter.EnvAdapterManager;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.task.AbstractRegisterTask;
import org.apache.servicecomb.serviceregistry.task.MicroserviceRegisterTask;
import org.apache.servicecomb.serviceregistry.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceInstanceRegisterTask
extends AbstractRegisterTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceInstanceRegisterTask.class);
    private final ServiceRegistryConfig serviceRegistryConfig;
    private final MicroserviceInstance microserviceInstance;
    private final ScheduledExecutorService addrCheckExecutor;
    private boolean isAddrCheckInit = false;

    public MicroserviceInstanceRegisterTask(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, ServiceRegistryClient srClient, Microservice microservice) {
        super(eventBus, srClient, microservice);
        this.serviceRegistryConfig = serviceRegistryConfig;
        this.microserviceInstance = microservice.getInstance();
        this.addrCheckExecutor = Executors.newScheduledThreadPool(1, t -> new Thread(t, "sc-addr-check"));
    }

    @Subscribe
    public void onMicroserviceRegisterTask(MicroserviceRegisterTask task) {
        if (task.taskStatus == TaskStatus.FINISHED && this.isSameMicroservice(task.getMicroservice())) {
            this.taskStatus = TaskStatus.READY;
            this.registered = false;
        } else {
            this.taskStatus = TaskStatus.INIT;
        }
    }

    @Override
    protected boolean doRegister() {
        LOGGER.info("running microservice instance register task.");
        String hostName = this.serviceRegistryConfig.isPreferIpAddress() ? RegistrationManager.getPublishAddress() : RegistrationManager.getPublishHostName();
        if (hostName.length() > 64) {
            hostName = hostName.substring(0, 64);
        }
        this.microserviceInstance.setHostName(hostName);
        this.microserviceInstance.getHealthCheck().setInterval(this.serviceRegistryConfig.getHeartbeatInterval());
        this.microserviceInstance.getHealthCheck().setTimes(this.serviceRegistryConfig.getResendHeartBeatTimes());
        EnvAdapterManager.INSTANCE.processInstanceWithAdapters(this.microserviceInstance);
        String instanceId = this.srClient.registerMicroserviceInstance(this.microserviceInstance);
        MicroserviceInstance temIns = this.srClient.findServiceInstance(this.microserviceInstance.getServiceId(), instanceId);
        if (temIns != null) {
            this.microserviceInstance.setTimestamp(temIns.getTimestamp());
        }
        if (StringUtils.isEmpty((CharSequence)instanceId)) {
            LOGGER.error("Register microservice instance failed,will back to register microservice again. microserviceId={}", (Object)this.microserviceInstance.getServiceId());
            return false;
        }
        this.microserviceInstance.setInstanceId(instanceId);
        LOGGER.info("Register microservice instance success. microserviceId={} instanceId={} endpoints={} lease {}s", new Object[]{this.microserviceInstance.getServiceId(), instanceId, this.microserviceInstance.getEndpoints(), this.microserviceInstance.getHealthCheck().getTTL()});
        if (!this.isAddrCheckInit) {
            this.addrCheckExecutor.scheduleWithFixedDelay(new CheckAddressTask(), 0L, this.serviceRegistryConfig.getHeartbeatInterval(), TimeUnit.SECONDS);
            this.isAddrCheckInit = true;
        }
        return true;
    }

    class CheckAddressTask
    implements Runnable {
        CheckAddressTask() {
        }

        @Override
        public void run() {
            MicroserviceInstanceRegisterTask.this.srClient.checkIsolationAddressAvailable();
        }
    }
}

