/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Extension;
import io.swagger.models.Operation;
import io.swagger.models.Scheme;
import io.swagger.util.BaseReaderUtils;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.AnnotationUtils;

public class ApiOperationProcessor
implements MethodAnnotationProcessor<ApiOperation> {
    private static final String SEPARATOR = ",";

    @Override
    public Type getProcessType() {
        return ApiOperation.class;
    }

    @Override
    public void process(SwaggerGenerator swaggerGenerator, OperationGenerator operationGenerator, ApiOperation apiOperationAnnotation) {
        Operation operation = operationGenerator.getOperation();
        operationGenerator.setHttpMethod(apiOperationAnnotation.httpMethod());
        if (!StringUtils.isEmpty((CharSequence)apiOperationAnnotation.value())) {
            operation.setSummary(apiOperationAnnotation.value());
        }
        if (!StringUtils.isEmpty((CharSequence)apiOperationAnnotation.notes())) {
            operation.setDescription(apiOperationAnnotation.notes());
        }
        operation.setOperationId(apiOperationAnnotation.nickname());
        operation.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])apiOperationAnnotation.extensions()));
        this.convertTags(apiOperationAnnotation.tags(), operation);
        SwaggerUtils.setCommaConsumes(operation, apiOperationAnnotation.consumes());
        SwaggerUtils.setCommaProduces(operation, apiOperationAnnotation.produces());
        this.convertProtocols(apiOperationAnnotation.protocols(), operation);
        AnnotationUtils.addResponse(swaggerGenerator.getSwagger(), operation, apiOperationAnnotation);
    }

    private void convertProtocols(String protocols, Operation operation) {
        if (protocols == null) {
            return;
        }
        for (String protocol : protocols.split(SEPARATOR)) {
            if (StringUtils.isEmpty((CharSequence)protocol)) continue;
            operation.addScheme(Scheme.forValue((String)protocol));
        }
    }

    private void convertTags(String[] tags, Operation operation) {
        if (tags == null || tags.length == 0) {
            return;
        }
        for (String tag : tags) {
            if (StringUtils.isEmpty((CharSequence)tag)) continue;
            operation.addTag(tag);
        }
    }
}

