/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.servicestage;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CasEnvConfig {
    private static final String APPLICATION_ID = "CAS_APPLICATION_ID";
    private static final String COMPONENT_NAME = "CAS_COMPONENT_NAME";
    private static final String INSTANCE_VERSION = "CAS_INSTANCE_VERSION";
    private static final String INSTANCE_ID = "CAS_INSTANCE_ID";
    private static final String ENVIRONMENT_ID = "CAS_ENVIRONMENT_ID";
    private static final String SERVICE_PROPS = "SERVICECOMB_SERVICE_PROPS";
    private static final String INSTANCE_PROPS = "SERVICECOMB_INSTANCE_PROPS";
    public static final CasEnvConfig INSTANCE = new CasEnvConfig();

    private Map<String, String> parseProps(String value) {
        HashMap<String, String> rs = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return rs;
        }
        return Arrays.stream(value.split(",")).map(v -> v.split(":")).filter(v -> ((String[])v).length == 2).collect(Collectors.toMap(v -> v[0], v -> v[1]));
    }

    public Map<String, String> getNonEmptyInstanceProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(APPLICATION_ID, DynamicPropertyFactory.getInstance().getStringProperty(APPLICATION_ID, "").get());
        map.put(COMPONENT_NAME, DynamicPropertyFactory.getInstance().getStringProperty(COMPONENT_NAME, "").get());
        map.put(INSTANCE_VERSION, DynamicPropertyFactory.getInstance().getStringProperty(INSTANCE_VERSION, "").get());
        map.put(INSTANCE_ID, DynamicPropertyFactory.getInstance().getStringProperty(INSTANCE_ID, "").get());
        map.put(ENVIRONMENT_ID, DynamicPropertyFactory.getInstance().getStringProperty(ENVIRONMENT_ID, "").get());
        Map<String, String> instanceProps = map.entrySet().stream().filter(entry -> StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        instanceProps.putAll(this.parseProps(DynamicPropertyFactory.getInstance().getStringProperty(INSTANCE_PROPS, "").get()));
        return instanceProps;
    }

    public Map<String, String> getNonEmptyServiceProperties() {
        return this.parseProps(DynamicPropertyFactory.getInstance().getStringProperty(SERVICE_PROPS, "").get());
    }
}

