/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.bools;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class BoolPackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new BoolPackedWriters(protoField));
    }

    private static class BoolPackedWriters
    extends AbstractPrimitiveWriters<boolean[], Boolean> {
        public BoolPackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (boolean element : array) {
                    output.writePackedBool(element);
                }
            });
            this.arrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (Boolean element : array) {
                    if (element != null) {
                        output.writePackedBool(element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
            this.collectionWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, collection) -> {
                for (Boolean element : collection) {
                    if (element != null) {
                        output.writePackedBool(element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
            this.stringArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (String element : array) {
                    if (element != null) {
                        boolean parsedValue = Boolean.parseBoolean(element);
                        output.writePackedBool(parsedValue);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
        }
    }
}

