/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.validator;

import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public final class ConfigurationPropertyUtils {
    private ConfigurationPropertyUtils() {
    }

    public static Map<String, String> getPropertiesWithPrefix(String prefix) {
        Object config = DynamicPropertyFactory.getBackingConfigurationSource();
        if (!Configuration.class.isInstance(config)) {
            return new HashMap<String, String>();
        }
        return ConfigurationPropertyUtils.getPropertiesWithPrefix((Configuration)config, prefix);
    }

    public static Map<String, String> getPropertiesWithPrefix(Configuration configuration, String prefix) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Iterator keysIterator = configuration.getKeys(prefix);
        while (keysIterator.hasNext()) {
            String key = (String)keysIterator.next();
            propertiesMap.put(key.substring(prefix.length() + 1), String.valueOf(configuration.getProperty(key)));
        }
        return propertiesMap;
    }
}

