/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.servicecomb.http.client.common.AbstractAddressManager;
import org.apache.servicecomb.http.client.common.HttpRequest;
import org.apache.servicecomb.http.client.common.HttpResponse;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCombServiceAvailableUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombServiceAvailableUtils.class);

    public static void checkAddressAvailable(AbstractAddressManager addressManager, String address, HttpTransport httpTransport, String path) {
        String formatUrl = addressManager.formatUrl(path, true, address);
        HttpRequest httpRequest = new HttpRequest(formatUrl, null, null, "GET");
        try {
            HttpResponse response = httpTransport.doRequest(httpRequest);
            if (response.getStatusCode() == 200) {
                addressManager.recordSuccessState(address);
                return;
            }
            if (response.getStatusCode() == 404 && ServiceCombServiceAvailableUtils.telnetCheckAddress(address)) {
                LOGGER.warn("[{}] path does not provide, tcp check address ready!", (Object)path);
                addressManager.recordSuccessState(address);
            }
        }
        catch (IOException e) {
            LOGGER.error("check isolation address [{}] available error!", (Object)address);
        }
    }

    public static boolean telnetCheckAddress(String address) {
        boolean bl;
        URI ipPort = ServiceCombServiceAvailableUtils.parseIpPortFromURI(address);
        if (ipPort == null) {
            return false;
        }
        Socket s = new Socket();
        try {
            s.connect(new InetSocketAddress(ipPort.getHost(), ipPort.getPort()), 3000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("ping endpoint {} failed, It will be quarantined again.", (Object)address);
                return false;
            }
        }
        s.close();
        return bl;
    }

    private static URI parseIpPortFromURI(String address) {
        try {
            Object newAddress = address.startsWith("http") ? address : "https://" + address;
            return new URI((String)newAddress);
        }
        catch (URISyntaxException e) {
            LOGGER.error("build uri error with address [{}].", (Object)address);
            return null;
        }
    }
}

