/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.ws;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.servicecomb.core.event.WebSocketActionEvent;

public class WebSocketAccessLogGenerator {
    public static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final Locale DEFAULT_LOCALE = Locale.US;
    public static final TimeZone TIME_ZONE = TimeZone.getDefault();
    private final ThreadLocal<SimpleDateFormat> datetimeFormatHolder = new ThreadLocal();

    public String generateServerLog(WebSocketActionEvent actionEvent) {
        return this.generateLog(actionEvent);
    }

    public String generateClientLog(WebSocketActionEvent actionEvent) {
        return this.generateLog(actionEvent);
    }

    private String generateLog(WebSocketActionEvent actionEvent) {
        return actionEvent.getInvocationType() + "|" + actionEvent.getOperationMeta().getMicroserviceQualifiedName() + "|" + this.formatTimestampToDateTimeStr(actionEvent.getActionStartTimestamp()) + "|" + actionEvent.getTraceId() + "|" + actionEvent.getConnectionId() + "|" + actionEvent.getActionType() + "|" + (actionEvent.getActionStartTimestamp() - actionEvent.getScheduleStartTimestamp()) + "|" + (actionEvent.getActionEndTimestamp() - actionEvent.getActionStartTimestamp()) + "|" + actionEvent.getHandleThreadName() + "|" + actionEvent.getDataSize();
    }

    private String formatTimestampToDateTimeStr(long timestamp) {
        return this.getDatetimeFormat().format(new Date(timestamp));
    }

    private SimpleDateFormat getDatetimeFormat() {
        SimpleDateFormat dateFormat = this.datetimeFormatHolder.get();
        if (null == dateFormat) {
            dateFormat = new SimpleDateFormat(DEFAULT_DATETIME_PATTERN, DEFAULT_LOCALE);
            dateFormat.setTimeZone(TIME_ZONE);
            this.datetimeFormatHolder.set(dateFormat);
        }
        return dateFormat;
    }
}

