/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.springframework.util.StringUtils;

public class PathProcessorCreator
implements ParamValueProcessorCreator {
    public static final String PARAMTYPE = "path";

    public PathProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(Parameter parameter, Type genericParamType) {
        JavaType targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        return new PathProcessor(parameter.getName(), targetType, ((PathParameter)parameter).getDefaultValue(), true);
    }

    public static class PathProcessor
    extends AbstractParamProcessor {
        public PathProcessor(String paramPath, JavaType targetType, Object defaultValue, boolean required) {
            super(paramPath, targetType, defaultValue, required);
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            Map pathVarMap = (Map)request.getAttribute("servicecomb-paths");
            if (pathVarMap == null) {
                return null;
            }
            String value = (String)pathVarMap.get(this.paramPath);
            if (value == null) {
                return null;
            }
            return this.convertValue(StringUtils.uriDecode((String)value, (Charset)StandardCharsets.UTF_8), this.targetType);
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
        }

        @Override
        public String getProcessorType() {
            return PathProcessorCreator.PARAMTYPE;
        }
    }
}

