/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.reactivex.rxjava3.core.Flowable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import org.apache.servicecomb.foundation.common.http.HttpStatus;
import org.apache.servicecomb.foundation.vertx.http.AbstractHttpServletResponse;

public class VertxClientResponseToHttpServletResponse
extends AbstractHttpServletResponse {
    private final HttpClientResponse clientResponse;
    private Response.StatusType statusType;
    private Flowable<Buffer> flowableBuffer;

    public VertxClientResponseToHttpServletResponse(HttpClientResponse clientResponse, Buffer bodyBuffer) {
        this.clientResponse = clientResponse;
        this.setBodyBuffer(bodyBuffer);
    }

    public VertxClientResponseToHttpServletResponse(HttpClientResponse clientResponse, Flowable<Buffer> buffer) {
        this.clientResponse = clientResponse;
        this.flowableBuffer = buffer;
    }

    @Override
    public int getStatus() {
        return this.clientResponse.statusCode();
    }

    @Override
    public Response.StatusType getStatusType() {
        if (this.statusType == null) {
            this.statusType = new HttpStatus(this.clientResponse.statusCode(), this.clientResponse.statusMessage());
        }
        return this.statusType;
    }

    @Override
    public String getContentType() {
        return this.clientResponse.getHeader("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        return this.clientResponse.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return this.clientResponse.headers().getAll(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.clientResponse.headers().names();
    }

    @Override
    public Flowable<Buffer> getFlowableBuffer() {
        return this.flowableBuffer;
    }
}

