/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.internal.converter;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.codec.protobuf.internal.converter.ProtoResponse;
import org.apache.servicecomb.swagger.invocation.context.HttpStatus;

public class ProtoMethod {
    private String argTypeName;
    @JsonProperty
    private Map<Integer, ProtoResponse> responses = new HashMap<Integer, ProtoResponse>();
    private ProtoResponse defaultResponse;

    public String getArgTypeName() {
        return this.argTypeName;
    }

    public void setArgTypeName(String argTypeName) {
        this.argTypeName = argTypeName;
    }

    public void addResponse(String status, ProtoResponse response) {
        if (status.equals("default")) {
            this.defaultResponse = response;
            return;
        }
        int statusCode = Integer.parseInt(status);
        this.responses.put(statusCode, response);
        if (this.defaultResponse == null && statusCode == Response.Status.OK.getStatusCode()) {
            this.defaultResponse = response;
        }
    }

    public ProtoResponse findResponse(int statusCode) {
        ProtoResponse response = this.responses.get(statusCode);
        if (response != null) {
            return response;
        }
        if (HttpStatus.isSuccess((int)statusCode)) {
            return this.responses.get(Response.Status.OK.getStatusCode());
        }
        return this.defaultResponse;
    }
}

