/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.provider.pojo.InvocationCaller;
import org.apache.servicecomb.provider.pojo.PojoConsumerMetaRefresher;
import org.apache.servicecomb.provider.pojo.PojoInvocation;
import org.apache.servicecomb.provider.pojo.PojoInvocationCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterInvocationCaller
implements InvocationCaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterInvocationCaller.class);

    @Override
    public Object call(Method method, PojoConsumerMetaRefresher metaRefresher, PojoInvocationCreator invocationCreator, Object[] args) {
        CompletionStage future = ((CompletableFuture)AsyncUtils.tryCatchSupplier(() -> invocationCreator.create(method, metaRefresher, args)).exceptionally(throwable -> this.logCreateInvocationException(method, (Throwable)throwable))).thenCompose(this::doCall);
        return InvokerUtils.isAsyncMethod((Method)method) ? future : AsyncUtils.toSync((CompletableFuture)future);
    }

    protected CompletableFuture<Object> doCall(@Nonnull PojoInvocation invocation) {
        return InvokerUtils.invoke((Invocation)invocation).thenApply(invocation::convertResponse);
    }

    protected PojoInvocation logCreateInvocationException(Method method, Throwable throwable) {
        LOGGER.error("failed to create invocation, method {}", (Object)method);
        throw Exceptions.consumer((String)"SCB_PROVIDER_POJO.400000001", (String)"failed to create invocation.", (Throwable)throwable);
    }
}

