/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.servicecomb.swagger.generator.core.processor.parameter;

import org.apache.servicecomb.swagger.generator.ParameterGenerator;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.FileSchema;
import jakarta.servlet.http.Part;

public class PartArrayParameterTypeProcessor extends PartParameterTypeProcessor {
  @Override
  public JavaType getProcessType() {
    return TypeFactory.defaultInstance().constructType(Part[].class);
  }

  @Override
  protected void formParameterSchema(ParameterGenerator parameterGenerator) {
    parameterGenerator.getParameterGeneratorContext().setSchema(new ArraySchema().items(new FileSchema()));
  }
}
