/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileOperations;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(scheme="file", title="File", syntax="file:directoryName", consumerClass=FileConsumer.class, label="core,file")
public class FileEndpoint
extends GenericFileEndpoint<File> {
    private final FileOperations operations = new FileOperations(this);
    @UriPath(name="directoryName")
    @Metadata(required="true")
    private File file;
    @UriParam(label="advanced", defaultValue="true")
    private boolean copyAndDeleteOnRenameFail = true;
    @UriParam(label="advanced")
    private boolean renameUsingCopy;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean forceWrites = true;

    public FileEndpoint() {
        this.readLock = "markerFile";
    }

    public FileEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.readLock = "markerFile";
    }

    @Override
    public FileConsumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull(this.operations, "operations");
        ObjectHelper.notNull(this.file, "file");
        if (!this.file.exists() && !this.file.isDirectory()) {
            if (this.isAutoCreate()) {
                this.log.debug("Creating non existing starting directory: {}", (Object)this.file);
                boolean absolute = FileUtil.isAbsolute(this.file);
                boolean created = this.operations.buildDirectory(this.file.getPath(), absolute);
                if (!created) {
                    this.log.warn("Cannot auto create starting directory: {}", (Object)this.file);
                }
            } else if (this.isStartingDirectoryMustExist()) {
                throw new FileNotFoundException("Starting directory does not exist: " + this.file);
            }
        }
        FileConsumer result = this.newFileConsumer(processor, this.operations);
        if (this.isDelete() && this.getMove() != null) {
            throw new IllegalArgumentException("You cannot set both delete=true and move options");
        }
        if (this.isNoop() && !this.isIdempotentSet()) {
            this.log.info("Endpoint is configured with noop=true so forcing endpoint to be idempotent as well");
            this.setIdempotent(true);
        }
        if (this.isIdempotentSet() && this.isIdempotent().booleanValue() && this.idempotentRepository == null) {
            this.log.info("Using default memory based idempotent repository with cache max size: 1000");
            this.idempotentRepository = MemoryIdempotentRepository.memoryIdempotentRepository(1000);
        }
        result.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        result.setEagerLimitMaxMessagesPerPoll(this.isEagerMaxMessagesPerPoll());
        this.configureConsumer(result);
        return result;
    }

    @Override
    public GenericFileProducer<File> createProducer() throws Exception {
        ObjectHelper.notNull(this.operations, "operations");
        if (this.getFileExist() == GenericFileExist.Append && (this.getTempPrefix() != null || this.getTempFileName() != null)) {
            throw new IllegalArgumentException("You cannot set both fileExist=Append and tempPrefix/tempFileName options");
        }
        if (this.getFileExist() == GenericFileExist.Move && this.getMoveExisting() == null) {
            throw new IllegalArgumentException("You must configure moveExisting option when fileExist=Move");
        }
        if (this.getMoveExisting() != null && this.getFileExist() != GenericFileExist.Move) {
            throw new IllegalArgumentException("You must configure fileExist=Move when moveExisting has been set");
        }
        return new GenericFileProducer<File>(this, this.operations);
    }

    @Override
    public Exchange createExchange(GenericFile<File> file) {
        Exchange exchange = this.createExchange();
        if (file != null) {
            file.bindToExchange(exchange);
        }
        return exchange;
    }

    protected FileConsumer newFileConsumer(Processor processor, GenericFileOperations<File> operations) {
        return new FileConsumer(this, processor, operations);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.getConfiguration().setDirectory(FileUtil.isAbsolute(file) ? file.getAbsolutePath() : file.getPath());
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    protected String createEndpointUri() {
        return this.getFile().toURI().toString();
    }

    @Override
    public char getFileSeparator() {
        return File.separatorChar;
    }

    @Override
    public boolean isAbsolute(String name) {
        return FileUtil.isAbsolute(new File(name));
    }

    public boolean isCopyAndDeleteOnRenameFail() {
        return this.copyAndDeleteOnRenameFail;
    }

    public void setCopyAndDeleteOnRenameFail(boolean copyAndDeleteOnRenameFail) {
        this.copyAndDeleteOnRenameFail = copyAndDeleteOnRenameFail;
    }

    public boolean isRenameUsingCopy() {
        return this.renameUsingCopy;
    }

    public void setRenameUsingCopy(boolean renameUsingCopy) {
        this.renameUsingCopy = renameUsingCopy;
    }

    public boolean isForceWrites() {
        return this.forceWrites;
    }

    public void setForceWrites(boolean forceWrites) {
        this.forceWrites = forceWrites;
    }
}

