/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodHelper;
import org.apache.camel.util.component.ApiName;

public abstract class ApiCollection<E extends Enum<E>, T> {
    protected final Map<E, ApiMethodHelper<? extends ApiMethod>> apis = new HashMap<E, ApiMethodHelper<? extends ApiMethod>>();
    protected final HashMap<Class<? extends ApiMethod>, E> apiMethods = new HashMap();

    public final Map<E, ApiMethodHelper<? extends ApiMethod>> getApiHelpers() {
        return Collections.unmodifiableMap(this.apis);
    }

    public final Map<Class<? extends ApiMethod>, E> getApiMethods() {
        return Collections.unmodifiableMap(this.apiMethods);
    }

    public final ApiMethodHelper<? extends ApiMethod> getHelper(E apiName) {
        return this.apis.get(apiName);
    }

    public final Set<String> getApiNames() {
        HashSet<String> result = new HashSet<String>();
        for (Enum api : this.apis.keySet()) {
            result.add(((ApiName)((Object)api)).getName());
        }
        return Collections.unmodifiableSet(result);
    }

    public final E getApiName(Class<? extends ApiMethod> apiMethod) {
        return (E)((Enum)this.apiMethods.get(apiMethod));
    }

    public abstract T getEndpointConfiguration(E var1);
}

