/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.features.internal.service.Blacklist;

public class RepositoryImpl
implements Repository {
    private final URI uri;
    private final String blacklisted;
    private Features features;

    public RepositoryImpl(URI uri) {
        this(uri, null);
    }

    public RepositoryImpl(URI uri, String blacklisted) {
        this.uri = uri;
        this.blacklisted = blacklisted;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getName() throws IOException {
        this.load();
        return this.features.getName();
    }

    @Override
    public URI[] getRepositories() throws IOException {
        this.load();
        URI[] result = new URI[this.features.getRepository().size()];
        for (int i = 0; i < this.features.getRepository().size(); ++i) {
            String uri = this.features.getRepository().get(i);
            uri = uri.trim();
            result[i] = URI.create(uri);
        }
        return result;
    }

    @Override
    public URI[] getResourceRepositories() throws IOException {
        this.load();
        URI[] result = new URI[this.features.getResourceRepository().size()];
        for (int i = 0; i < this.features.getResourceRepository().size(); ++i) {
            String uri = this.features.getResourceRepository().get(i);
            uri = uri.trim();
            result[i] = URI.create(uri);
        }
        return result;
    }

    @Override
    public Feature[] getFeatures() throws IOException {
        this.load();
        return this.features.getFeature().toArray(new Feature[this.features.getFeature().size()]);
    }

    public void load() throws IOException {
        this.load(false);
    }

    public void load(boolean validate) throws IOException {
        if (this.features == null) {
            try (InterruptibleInputStream inputStream = new InterruptibleInputStream(this.uri.toURL().openStream());){
                this.features = JaxbUtil.unmarshal(this.uri.toASCIIString(), inputStream, validate);
                Blacklist.blacklist(this.features, this.blacklisted);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage() + " : " + this.uri, e);
            }
        }
    }

    static class InterruptibleInputStream
    extends FilterInputStream {
        InterruptibleInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            return super.read(b, off, len);
        }
    }
}

