/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region.hook;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.equinox.internal.region.hook.RegionDigraphVisitorBase;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.bundle.CollisionHook;

public final class RegionBundleCollisionHook
implements CollisionHook {
    private final RegionDigraph regionDigraph;
    private final ThreadLocal<Region> threadLocal;

    public RegionBundleCollisionHook(RegionDigraph regionDigraph, ThreadLocal<Region> threadLocal) {
        this.regionDigraph = regionDigraph;
        this.threadLocal = threadLocal;
    }

    private Region getInstallRegion(Bundle originBundle) {
        Region installRegion = this.threadLocal.get();
        if (installRegion != null) {
            return installRegion;
        }
        return this.regionDigraph.getRegion(originBundle);
    }

    public void filterCollisions(int operationType, Bundle target, Collection<Bundle> collisionCandidates) {
        Region targetRegion = this.getInstallRegion(target);
        if (targetRegion == null) {
            return;
        }
        VisitorFromTarget fromTarget = new VisitorFromTarget(collisionCandidates);
        targetRegion.visitSubgraph(fromTarget);
        Collection collisions = fromTarget.getAllowed();
        if (collisions.isEmpty()) {
            for (Bundle collisionCandidate : collisionCandidates) {
                Region candidateRegion = this.regionDigraph.getRegion(collisionCandidate);
                VisitorFromCandidate fromCandidate = new VisitorFromCandidate(Arrays.asList(collisionCandidate), targetRegion);
                candidateRegion.visitSubgraph(fromCandidate);
                collisions = fromCandidate.getAllowed();
                if (!collisions.isEmpty()) break;
            }
        }
        collisionCandidates.retainAll(collisions);
    }

    class VisitorFromCandidate
    extends RegionDigraphVisitorBase<Bundle> {
        private final Region targetRegion;

        VisitorFromCandidate(Collection<Bundle> candidates, Region targetRegion) {
            super(candidates);
            this.targetRegion = targetRegion;
        }

        @Override
        protected boolean contains(Region region, Bundle candidate) {
            return region.equals(this.targetRegion);
        }

        @Override
        protected boolean isAllowed(Bundle candidate, RegionFilter filter) {
            return filter.isAllowed(candidate);
        }
    }

    class VisitorFromTarget
    extends RegionDigraphVisitorBase<Bundle> {
        VisitorFromTarget(Collection<Bundle> candidates) {
            super(candidates);
        }

        @Override
        protected boolean contains(Region region, Bundle candidate) {
            return region.contains(candidate);
        }

        @Override
        protected boolean isAllowed(Bundle candidate, RegionFilter filter) {
            return filter.isAllowed(candidate);
        }
    }
}

