/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="shell", name="head", description="Displays the first lines of a file.")
@Service
public class HeadAction
implements Action {
    private static final int DEFAULT_NUMBER_OF_LINES = 10;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-n", aliases={}, description="The number of lines to display, starting at 1.", required=false, multiValued=false)
    private int numberOfLines;
    @Argument(index=0, name="paths or urls", description="A list of file paths or urls to display separated by whitespaces.", required=false, multiValued=true)
    private List<String> paths;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        if (this.paths == null || this.paths.size() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Heading STDIN");
            }
            this.head(new BufferedReader(new InputStreamReader(System.in)));
        } else {
            for (String filename : this.paths) {
                BufferedReader reader;
                try {
                    URL url = new URL(filename);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Heading URL: " + url);
                    }
                    reader = new BufferedReader(new InputStreamReader(url.openStream()));
                }
                catch (MalformedURLException ignore) {
                    File file = new File(filename);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Heading file: " + file);
                    }
                    reader = new BufferedReader(new FileReader(file));
                }
                try {
                    this.head(reader);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    private void head(BufferedReader reader) throws IOException {
        String line;
        int lineno = 1;
        if (this.numberOfLines < 1) {
            this.numberOfLines = 10;
        }
        while ((line = reader.readLine()) != null && lineno <= this.numberOfLines) {
            System.out.println(line);
            ++lineno;
        }
    }
}

