/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.context.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.StringTokenizer;

public class MappingMetaData {
    private Properties properties;
    private String packageName;

    public MappingMetaData(String packageName) {
        this.packageName = packageName;
        this.properties = new Properties();
    }

    public MappingMetaData(Properties properties) {
        this.properties = properties;
    }

    public String getClassName(String localName) {
        String className = this.properties.getProperty(localName);
        if (className == null && this.packageName != null) {
            className = this.packageName.length() > 0 ? this.packageName + "." + localName : localName;
        }
        return className;
    }

    public String getPropertyName(String elementName, String attributeName) {
        return this.properties.getProperty(elementName + ".alias." + attributeName, attributeName);
    }

    public String getNestedListProperty(String elementName, String childElementName) {
        return this.properties.getProperty(elementName + ".list." + childElementName);
    }

    public String getNestedProperty(String elementName, String childElementName) {
        return this.properties.getProperty(elementName + ".alias." + childElementName);
    }

    public boolean isDefaultConstructor(Constructor constructor) {
        String property = this.properties.getProperty(MappingMetaData.constructorToPropertyName(constructor) + ".default");
        if (property != null) {
            return Boolean.valueOf(property);
        }
        return false;
    }

    public boolean isDefaultFactoryMethod(Class beanClass, Method factoryMethod) {
        String property = this.properties.getProperty(MappingMetaData.methodToPropertyName(beanClass, factoryMethod) + ".default");
        if (property != null) {
            return Boolean.valueOf(property);
        }
        return false;
    }

    public String[] getParameterNames(Constructor constructor) {
        String property = this.properties.getProperty(MappingMetaData.constructorToPropertyName(constructor) + ".parameterNames");
        if (property != null) {
            ArrayList<Object> names = Collections.list(new StringTokenizer(property, ", "));
            return names.toArray(new String[0]);
        }
        return null;
    }

    public String[] getParameterNames(Class beanClass, Method factoryMethod) {
        String property = this.properties.getProperty(MappingMetaData.methodToPropertyName(beanClass, factoryMethod) + ".parameterNames");
        if (property != null) {
            ArrayList<Object> names = Collections.list(new StringTokenizer(property, ", "));
            return names.toArray(new String[0]);
        }
        return null;
    }

    public static String constructorToPropertyName(Constructor constructor) {
        StringBuffer buf = new StringBuffer();
        buf.append(constructor.getName()).append("(");
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            buf.append(parameterType.getName());
            if (i >= parameterTypes.length - 1) continue;
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    public static String methodToPropertyName(Class beanClass, Method method) {
        StringBuffer buf = new StringBuffer();
        buf.append(beanClass.getName()).append(".");
        buf.append(method.getName()).append("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            buf.append(parameterType.getName());
            if (i >= parameterTypes.length - 1) continue;
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    public String getInitMethodName(String elementName) {
        return this.properties.getProperty(elementName + ".initMethod");
    }

    public String getDestroyMethodName(String elementName) {
        return this.properties.getProperty(elementName + ".destroyMethod");
    }

    public String getFactoryMethodName(String elementName) {
        return this.properties.getProperty(elementName + ".factoryMethod");
    }

    public String getContentProperty(String elementName) {
        return this.properties.getProperty(elementName + ".contentProperty");
    }

    public String getMapEntryName(String elementName, String property) {
        return this.properties.getProperty(elementName + "." + property + ".map.entryName");
    }

    public String getMapKeyName(String elementName, String property) {
        return this.properties.getProperty(elementName + "." + property + ".map.keyName");
    }

    public boolean isFlatMap(String elementName, String property) {
        return this.properties.getProperty(elementName + "." + property + ".map.flat") != null;
    }

    public String getMapDupsMode(String elementName, String property) {
        return this.properties.getProperty(elementName + "." + property + ".map.dups");
    }

    public String getMapDefaultKey(String elementName, String property) {
        return this.properties.getProperty(elementName + "." + property + ".map.defaultKey");
    }

    public String getFlatCollectionProperty(String elementName, String property) {
        return this.properties.getProperty(elementName + "." + property + ".flatCollection");
    }

    public boolean isFlatProperty(String elementName, String property) {
        return this.properties.getProperty(elementName + "." + property + ".flat") != null;
    }

    public String getPropertyEditor(String elementName, String property) {
        return this.properties.getProperty(elementName + "." + property + ".propertyEditor");
    }
}

