/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.indexer;

import aQute.bnd.indexer.ResourceAnalyzer;
import aQute.bnd.indexer.analyzers.BlueprintAnalyzer;
import aQute.bnd.indexer.analyzers.BundleAnalyzer;
import aQute.bnd.indexer.analyzers.OSGiFrameworkAnalyzer;
import aQute.bnd.indexer.analyzers.SCRAnalyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.resource.ResourceBuilder;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.osgi.resource.Resource;

public class RepoIndex {
    static final String VERSION = "2.1";
    final List<ResourceAnalyzer> analyzers = new ArrayList<ResourceAnalyzer>();

    public RepoIndex() {
        this.analyzers.add(new BundleAnalyzer());
        this.analyzers.add(new OSGiFrameworkAnalyzer());
        this.analyzers.add(new SCRAnalyzer());
        this.analyzers.add(new BlueprintAnalyzer());
    }

    public IndexResult indexFile(File file, URI url) throws Exception {
        Jar jar = new Jar(file);
        IndexResult result = new IndexResult();
        result.resource = null;
        result.signature = this.getSignature();
        ArrayList capabilities = new ArrayList();
        ArrayList requirements = new ArrayList();
        ResourceBuilder rb = new ResourceBuilder();
        for (ResourceAnalyzer analyzer : this.analyzers) {
            analyzer.analyzeResource(jar, rb);
        }
        result.resource = rb.build();
        return result;
    }

    public long getSignature() {
        return VERSION.hashCode();
    }

    public static class IndexResult {
        public Resource resource;
        public long signature;
    }
}

